/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import one.util.streamex.EntryStream;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.ParameterProvider;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJobIdentifier;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.rest.ExecutionInfo;

@JsonAutoDetect
@JsonPropertyOrder(value={"execution", "results"})
public class SearchJob
implements ParameterProvider {
    public static final Integer NO_CANCELLATION = 0;
    @JsonUnwrapped
    private SearchJobIdentifier searchJobIdentifier;
    private final Search search;
    private Future<?> searchEngineTaskFuture;
    private CompletableFuture<Void> resultFuture;
    private final Map<String, CompletableFuture<QueryResult>> queryResults = Maps.newHashMap();
    private Set<SearchError> errors = Sets.newHashSet();
    private final Integer cancelAfterSeconds;

    public SearchJob(String id, Search search, String owner, String executingNodeId) {
        this(id, search, owner, executingNodeId, NO_CANCELLATION);
    }

    public SearchJob(String id, Search search, String owner, String executingNodeId, Integer cancelAfterSeconds) {
        this.search = search;
        this.searchJobIdentifier = new SearchJobIdentifier(id, search.id(), owner, executingNodeId);
        this.cancelAfterSeconds = cancelAfterSeconds != null ? cancelAfterSeconds : NO_CANCELLATION;
    }

    @JsonIgnore
    public String getId() {
        return this.searchJobIdentifier.id();
    }

    @JsonIgnore
    public Search getSearch() {
        return this.search;
    }

    @JsonProperty(value="cancel_after_seconds")
    public Integer getCancelAfterSeconds() {
        return this.cancelAfterSeconds;
    }

    @JsonIgnore
    public SearchJobIdentifier getSearchJobIdentifier() {
        return this.searchJobIdentifier;
    }

    @JsonIgnore
    public String getSearchId() {
        return this.searchJobIdentifier.searchId();
    }

    @JsonIgnore
    public String getOwner() {
        return this.searchJobIdentifier.owner();
    }

    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Set<SearchError> getErrors() {
        return this.errors;
    }

    @JsonIgnore
    public CompletableFuture<Void> getResultFuture() {
        return this.resultFuture;
    }

    public void addQueryResultFuture(String queryId, CompletableFuture<QueryResult> resultFuture) {
        this.queryResults.put(queryId, resultFuture);
    }

    @JsonIgnore
    public void setSearchEngineTaskFuture(Future<?> searchEngineTaskFuture) {
        this.searchEngineTaskFuture = searchEngineTaskFuture;
    }

    public void cancel() {
        if (this.searchEngineTaskFuture != null) {
            this.searchEngineTaskFuture.cancel(true);
        }
    }

    @JsonProperty(value="results")
    public Map<String, QueryResult> results() {
        return EntryStream.of(this.queryResults).mapValues(future -> future.getNow(QueryResult.incomplete())).filterKeys(queryId -> !queryId.isEmpty()).filterValues(r -> r.state() == QueryResult.State.COMPLETED || r.state() == QueryResult.State.FAILED).toMap();
    }

    @JsonProperty(value="execution")
    public ExecutionInfo execution() {
        boolean isDone = !(this.resultFuture != null && !this.resultFuture.isDone() || this.searchEngineTaskFuture != null && !this.searchEngineTaskFuture.isDone());
        boolean isCancelled = this.searchEngineTaskFuture != null && this.searchEngineTaskFuture.isCancelled() || this.resultFuture != null && this.resultFuture.isCancelled();
        return new ExecutionInfo(isDone, isCancelled, !this.errors.isEmpty());
    }

    public CompletableFuture<QueryResult> getQueryResultFuture(String queryId) {
        return this.queryResults.get(queryId);
    }

    @JsonIgnore
    public SearchJob seal() {
        this.resultFuture = CompletableFuture.allOf(this.queryResults.values().toArray(new CompletableFuture[0]));
        return this;
    }

    public void addError(SearchError t) {
        this.errors.add(t);
    }

    @Override
    public Optional<Parameter> getParameter(String name) {
        return this.getSearch().getParameter(name);
    }
}

