/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.db;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ForbiddenException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.db.SearchJobService;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.utilities.StringUtils;

@Singleton
public class InMemorySearchJobService
implements SearchJobService {
    private final Cache<String, SearchJob> cache;
    private final NodeId nodeId;

    @Inject
    public InMemorySearchJobService(NodeId nodeId) {
        this.nodeId = nodeId;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(1000L).recordStats().build();
    }

    @Override
    public SearchJob create(Search search, String owner, Integer cancelAfterSeconds) {
        String id = new ObjectId().toHexString();
        SearchJob searchJob = new SearchJob(id, search, owner, this.nodeId.getNodeId(), cancelAfterSeconds);
        this.cache.put((Object)id, (Object)searchJob);
        return searchJob;
    }

    @Override
    public Optional<SearchJob> load(String id, SearchUser searchUser) throws ForbiddenException {
        SearchJob searchJob = (SearchJob)this.cache.getIfPresent((Object)id);
        if (searchJob == null) {
            return Optional.empty();
        }
        if (searchJob.getOwner().equals(searchUser.username()) || searchUser.isAdmin()) {
            return Optional.of(searchJob);
        }
        throw new ForbiddenException(StringUtils.f("User %s cannot load search job %s that belongs to different user!", searchUser.username(), id));
    }
}

