/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;
import org.graylog2.streams.StreamService;

public class FieldTypesLookup {
    private final IndexFieldTypesService indexFieldTypesService;
    private final StreamService streamService;

    @Inject
    public FieldTypesLookup(IndexFieldTypesService indexFieldTypesService, StreamService streamService) {
        this.indexFieldTypesService = indexFieldTypesService;
        this.streamService = streamService;
    }

    private Map<String, Set<String>> get(Set<String> streamIds) {
        return this.findForStreamIds(streamIds).stream().flatMap(indexFieldTypes -> indexFieldTypes.fields().stream()).collect(Collectors.toMap(FieldTypeDTO::fieldName, fieldType -> Collections.singleton(fieldType.physicalType()), Sets::union));
    }

    private Collection<IndexFieldTypesDTO> findForStreamIds(Collection<String> streamIds) {
        Set<String> indexSetIds = this.getIndexSetIds(streamIds);
        return this.indexFieldTypesService.findForIndexSets(indexSetIds);
    }

    @Nonnull
    private Set<String> getIndexSetIds(Collection<String> streamIds) {
        return this.streamService.loadByIds(streamIds).stream().filter(Objects::nonNull).map(stream -> stream.getIndexSet().getConfig().id()).collect(Collectors.toSet());
    }

    public Optional<String> getType(Set<String> streamIds, String field) {
        Map<String, Set<String>> allFieldTypes = this.get(streamIds);
        Set<String> fieldTypes = allFieldTypes.get(field);
        return this.typeFromFieldType(fieldTypes);
    }

    public Map<String, String> getTypes(Set<String> streamIds, Set<String> fields) {
        Map<String, Set<String>> allFieldTypes = this.get(streamIds);
        HashMap<String, String> result = new HashMap<String, String>(fields.size());
        fields.forEach(field -> {
            Set fieldTypes = (Set)allFieldTypes.get(field);
            this.typeFromFieldType(fieldTypes).ifPresent(s -> result.put((String)field, (String)s));
        });
        return result;
    }

    private Optional<String> typeFromFieldType(Set<String> fieldTypes) {
        return fieldTypes == null || fieldTypes.size() > 1 ? Optional.empty() : fieldTypes.stream().findFirst();
    }
}

