/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.IndexRangeContainsOneOfStreams;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;

public class IndexLookup {
    private final IndexRangeService indexRangeService;
    private final StreamService streamService;
    private final IndexRangeContainsOneOfStreams indexRangeContainsOneOfStreams;

    @Inject
    public IndexLookup(IndexRangeService indexRangeService, StreamService streamService) {
        this.indexRangeService = indexRangeService;
        this.streamService = streamService;
        this.indexRangeContainsOneOfStreams = new IndexRangeContainsOneOfStreams();
    }

    IndexLookup(IndexRangeService indexRangeService, StreamService streamService, IndexRangeContainsOneOfStreams indexRangeContainsOneOfStreams) {
        this.indexRangeService = indexRangeService;
        this.streamService = streamService;
        this.indexRangeContainsOneOfStreams = indexRangeContainsOneOfStreams;
    }

    public Set<String> indexNamesForStreamsInTimeRange(Set<String> streamIds, TimeRange timeRange) {
        Set dataStreamIndices = streamIds.stream().filter(s -> s.startsWith("datastream:")).map(s -> s.substring("datastream:".length())).collect(Collectors.toSet());
        Set candidateIndices = this.indexRangesForStreamsInTimeRange(streamIds, timeRange).stream().map(IndexRange::indexName).collect(Collectors.toSet());
        return Sets.union(dataStreamIndices, candidateIndices);
    }

    public Set<IndexRange> indexRangesForStreamsInTimeRange(Set<String> streamIds, TimeRange timeRange) {
        if (streamIds.isEmpty()) {
            return Set.of();
        }
        Set<String> nonDataStreamIds = streamIds.stream().filter(s -> !s.startsWith("datastream:")).collect(Collectors.toSet());
        Set<Stream> usedStreams = this.streamService.loadByIds(nonDataStreamIds);
        SortedSet<IndexRange> candidateIndices = this.indexRangeService.find(timeRange.getFrom(), timeRange.getTo());
        return candidateIndices.stream().filter(i -> this.indexRangeContainsOneOfStreams.test((IndexRange)i, usedStreams)).collect(Collectors.toSet());
    }
}

