/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.normalization;

import com.google.common.base.MoreObjects;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.ParameterProvider;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.engine.normalization.PostValidation;
import org.graylog.plugins.views.search.engine.normalization.SearchNormalization;
import org.graylog.plugins.views.search.engine.normalization.SearchNormalizer;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog.plugins.views.search.rest.ExecutionStateGlobalOverride;
import org.graylog2.plugin.Tools;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;

public class PluggableSearchNormalization
implements SearchNormalization {
    private final Set<SearchNormalizer> pluggableNormalizers;
    private final Set<SearchNormalizer> postValidationNormalizers;
    private final Function<Collection<String>, Stream<String>> streamCategoryMapper;

    @Inject
    public PluggableSearchNormalization(Set<SearchNormalizer> pluggableNormalizers, @PostValidation Set<SearchNormalizer> postValidationNormalizers, StreamService streamService) {
        this.pluggableNormalizers = pluggableNormalizers;
        this.postValidationNormalizers = postValidationNormalizers;
        this.streamCategoryMapper = categories -> streamService.mapCategoriesToIds((Collection<String>)categories).stream();
    }

    public PluggableSearchNormalization(Set<SearchNormalizer> pluggableNormalizers, StreamService streamService) {
        this(pluggableNormalizers, Collections.emptySet(), streamService);
    }

    private Search normalize(Search search, Set<SearchNormalizer> normalizers) {
        Search normalizedSearch = search;
        for (SearchNormalizer searchNormalizer : normalizers) {
            normalizedSearch = searchNormalizer.normalize(normalizedSearch);
        }
        return normalizedSearch;
    }

    private Query normalize(Query query, ParameterProvider parameterProvider, Set<SearchNormalizer> normalizers) {
        Query normalizedQuery = query;
        for (SearchNormalizer searchNormalizer : normalizers) {
            normalizedQuery = searchNormalizer.normalizeQuery(normalizedQuery, parameterProvider);
        }
        return normalizedQuery;
    }

    @Override
    public Search preValidation(Search search, SearchUser searchUser, ExecutionState executionState) {
        Search searchWithStreams = search.addStreamsToQueriesWithCategories(this.streamCategoryMapper, searchUser).addStreamsToSearchTypesWithCategories(this.streamCategoryMapper, searchUser).addStreamsToQueriesWithoutStreams(() -> searchUser.streams().loadMessageStreamsWithFallback());
        DateTime now = this.referenceDateFromOverrideOrNow(executionState);
        Search normalizedSearch = searchWithStreams.applyExecutionState((ExecutionState)MoreObjects.firstNonNull((Object)executionState, (Object)ExecutionState.empty())).withReferenceDate(now);
        return this.normalize(normalizedSearch, this.pluggableNormalizers);
    }

    private DateTime referenceDateFromOverrideOrNow(ExecutionState executionState) {
        return Optional.ofNullable(executionState).map(ExecutionState::globalOverride).flatMap(ExecutionStateGlobalOverride::now).orElse(Tools.nowUTC());
    }

    @Override
    public Search postValidation(Search search, SearchUser searchUser, ExecutionState executionState) {
        return this.normalize(search, this.postValidationNormalizers);
    }

    @Override
    public Query preValidation(Query query, ParameterProvider parameterProvider, SearchUser searchUser, ExecutionState executionState) {
        Query normalizedQuery = query;
        if (!query.hasStreams()) {
            normalizedQuery = query.addStreamsToFilter((Set<String>)searchUser.streams().loadMessageStreamsWithFallback());
        } else if (!query.usedStreamCategories().isEmpty()) {
            normalizedQuery = query.replaceStreamCategoryFilters(this.streamCategoryMapper, searchUser);
        }
        if (!executionState.equals(ExecutionState.empty())) {
            normalizedQuery = normalizedQuery.applyExecutionState(executionState);
        }
        return this.normalize(normalizedQuery, parameterProvider, this.pluggableNormalizers);
    }

    @Override
    public Query postValidation(Query query, ParameterProvider parameterProvider) {
        return this.normalize(query, parameterProvider, this.postValidationNormalizers);
    }
}

