/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.validation;

import jakarta.inject.Inject;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchExecutionGuard;
import org.graylog.plugins.views.search.engine.validation.SearchValidation;
import org.graylog.plugins.views.search.engine.validation.SearchValidator;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.permissions.SearchUser;

public class PluggableSearchValidation
implements SearchValidation {
    private final SearchExecutionGuard executionGuard;
    private final Set<SearchValidator> pluggableSearchValidators;

    @Inject
    public PluggableSearchValidation(SearchExecutionGuard executionGuard, Set<SearchValidator> pluggableSearchValidators) {
        this.executionGuard = executionGuard;
        this.pluggableSearchValidators = pluggableSearchValidators;
    }

    @Override
    public Set<SearchError> validate(Search search, SearchUser searchUser) {
        this.executionGuard.check(search, searchUser::canReadStream);
        return this.pluggableSearchValidators.stream().flatMap(validator -> validator.validate(search, searchUser).stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<SearchError> validate(Query query, SearchUser searchUser) {
        this.executionGuard.checkUserIsPermittedToSeeStreams(query.streamIdsForPermissionsCheck(), searchUser::canReadStream);
        return this.pluggableSearchValidators.stream().flatMap(validator -> validator.validate(query, searchUser).stream()).collect(Collectors.toSet());
    }
}

