/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Positive;
import java.util.LinkedHashSet;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.export.AutoValue_ResultFormat;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.LinkedHashSetUtil;
import org.graylog.plugins.views.search.rest.ExecutionState;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.joda.time.DateTimeZone;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ResultFormat {
    private static final String FIELD_FIELDS = "fields_in_order";

    @JsonProperty(value="fields_in_order")
    @NotEmpty
    public abstract LinkedHashSet<String> fieldsInOrder();

    @JsonProperty
    public abstract Optional<AbsoluteRange> timerange();

    @JsonProperty
    public abstract Optional<Integer> limit();

    @JsonProperty
    public abstract ExecutionState executionState();

    @JsonProperty
    public abstract Optional<String> filename();

    @JsonProperty
    public abstract Optional<DateTimeZone> timeZone();

    public static Builder builder() {
        return Builder.create();
    }

    public static ResultFormat empty() {
        return ResultFormat.builder().build();
    }

    public ResultFormat withTimeZone(DateTimeZone timeZone) {
        return this.toBuilder().timeZone(timeZone).build();
    }

    abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="fields_in_order")
        public abstract Builder fieldsInOrder(LinkedHashSet<String> var1);

        public Builder fieldsInOrder(String ... fields) {
            return this.fieldsInOrder(LinkedHashSetUtil.linkedHashSetOf(fields));
        }

        @JsonProperty
        public abstract Builder limit(@Positive @Nullable Integer var1);

        @JsonProperty
        public abstract Builder executionState(ExecutionState var1);

        @JsonProperty
        public abstract Builder timerange(@Nullable AbsoluteRange var1);

        @JsonProperty
        public abstract Builder filename(@Nullable String var1);

        @JsonProperty
        public abstract Builder timeZone(@Nullable DateTimeZone var1);

        public abstract ResultFormat build();

        @JsonCreator
        public static Builder create() {
            return new AutoValue_ResultFormat.Builder().fieldsInOrder(ExportMessagesCommand.DEFAULT_FIELDS).executionState(ExecutionState.empty());
        }
    }
}

