/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Set;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.FieldTypesForStreamsRequest;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.fieldtypes.IndexFieldTypePollerPeriodical;
import org.graylog2.indexer.fieldtypes.MappedFieldTypesService;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="FieldTypes", tags={"cloud"})
@Path(value="/views/fields")
@Produces(value={"application/json"})
@RequiresAuthentication
public class FieldTypesResource
extends RestResource
implements PluginRestResource {
    private final MappedFieldTypesService mappedFieldTypesService;
    private final IndexFieldTypePollerPeriodical fieldTypePoller;

    @Inject
    public FieldTypesResource(MappedFieldTypesService mappedFieldTypesService, IndexFieldTypePollerPeriodical fieldTypePoller) {
        this.mappedFieldTypesService = mappedFieldTypesService;
        this.fieldTypePoller = fieldTypePoller;
    }

    @GET
    @ApiOperation(value="Retrieve the list of all fields present in the system")
    public Set<MappedFieldTypeDTO> allFieldTypes(@Context SearchUser searchUser) {
        ImmutableSet<String> streams = searchUser.streams().loadAllMessageStreams();
        return this.mappedFieldTypesService.fieldTypesByStreamIds((Collection<String>)streams, RelativeRange.allTime());
    }

    @POST
    @ApiOperation(value="Retrieve the field list of a given set of streams")
    @NoAuditEvent(value="This is not changing any data")
    public Set<MappedFieldTypeDTO> byStreams(@ApiParam(name="JSON body", required=true) @Valid @NotNull FieldTypesForStreamsRequest request, @Context SearchUser searchUser) {
        ImmutableSet<String> streams = searchUser.streams().readableOrAllIfEmpty(request.streams());
        return this.mappedFieldTypesService.fieldTypesByStreamIds((Collection<String>)streams, request.timerange().orElse(RelativeRange.allTime()));
    }

    @POST
    @ApiOperation(value="Trigger a full refresh of field types")
    @Path(value="/poll")
    @RequiresPermissions(value={"*"})
    @AuditEvent(type="server:field_type_polling:trigger")
    public Response triggerFieldTypePolling() {
        this.fieldTypePoller.triggerFullRefresh();
        return Response.noContent().build();
    }
}

