/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.permissions.StreamPermissions;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.streams.StreamService;

public class PermittedStreams {
    private final Supplier<Stream<String>> allStreamsProvider;
    private final Function<Collection<String>, Stream<String>> streamCategoryMapper;

    public PermittedStreams(Supplier<Stream<String>> allStreamsProvider, Function<Collection<String>, Stream<String>> streamCategoryMapper) {
        this.allStreamsProvider = allStreamsProvider;
        this.streamCategoryMapper = streamCategoryMapper;
    }

    @Inject
    public PermittedStreams(StreamService streamService) {
        this(() -> streamService.loadAll().stream().map(Persisted::getId), categories -> streamService.mapCategoriesToIds((Collection<String>)categories).stream());
    }

    public ImmutableSet<String> loadAllMessageStreams(StreamPermissions streamPermissions) {
        return (ImmutableSet)this.allStreamsProvider.get().filter(id -> !org.graylog2.plugin.streams.Stream.NON_MESSAGE_STREAM_IDS.contains(id)).filter(streamPermissions::canReadStream).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSet<String> loadAll(StreamPermissions streamPermissions) {
        return (ImmutableSet)this.allStreamsProvider.get().filter(streamPermissions::canReadStream).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSet<String> loadWithCategories(Collection<String> categories, StreamPermissions streamPermissions) {
        return (ImmutableSet)this.streamCategoryMapper.apply(categories).filter(streamPermissions::canReadStream).collect(ImmutableSet.toImmutableSet());
    }
}

