/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.export;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.searchtypes.export.ExportTabularResultResponse;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.rest.RestTools;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Search/Pivot/Export", tags={"cloud"})
@Path(value="/views/search/pivot/export")
@RequiresAuthentication
@Consumes(value={"application/json"})
public class AggregationWidgetExportResource
extends RestResource {
    @ApiOperation(value="Export widget data")
    @POST
    @NoAuditEvent(value="Exporting widget data does not need audit event")
    @Produces(value={"text/csv", "application/json", "application/yaml", "application/xml", "application/vnd.ms-excel"})
    @Path(value="/{filename}")
    public Response exportData(@ApiParam @Valid PivotResult pivotResult, @HeaderParam(value="Accept") String mediaType, @ApiParam(value="filename") @PathParam(value="filename") String filename) {
        return RestTools.respondWithFile(filename, ExportTabularResultResponse.fromPivotResult(pivotResult), MediaType.valueOf((String)mediaType)).build();
    }
}

