/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Grouping;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Metric;
import org.graylog.plugins.views.search.rest.scriptingapi.request.SearchRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseSchemaEntry;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public record AggregationRequestSpec(@JsonProperty(value="query") String queryString, @JsonProperty(value="streams") Set<String> streams, @JsonProperty(value="stream_categories") Set<String> streamCategories, @JsonProperty(value="timerange") TimeRange timerange, @JsonProperty(value="group_by") @Valid @NotEmpty List<Grouping> groupings, @JsonProperty(value="metrics") @Valid @NotEmpty List<Metric> metrics) implements SearchRequestSpec
{
    public AggregationRequestSpec(@JsonProperty(value="query") String queryString, @JsonProperty(value="streams") Set<String> streams, @JsonProperty(value="stream_categories") Set<String> streamCategories, @JsonProperty(value="timerange") TimeRange timerange, @JsonProperty(value="group_by") @Valid @NotEmpty List<Grouping> groupings, @JsonProperty(value="metrics") @Valid @NotEmpty List<Metric> metrics) {
        if (Strings.isNullOrEmpty((String)queryString)) {
            queryString = "*";
        }
        if (timerange == null) {
            timerange = DEFAULT_TIMERANGE;
        }
        if (streams == null) {
            streams = Set.of();
        }
        if (streamCategories == null) {
            streamCategories = Set.of();
        }
    }

    public boolean hasCustomSort() {
        return this.metrics().stream().anyMatch(m -> m.sort() != null);
    }

    @JsonIgnore
    public List<ResponseSchemaEntry> getSchema() {
        Stream<ResponseSchemaEntry> groupings = this.groupings().stream().map(gr -> ResponseSchemaEntry.groupBy(gr.requestedField().toString()));
        Stream<ResponseSchemaEntry> metrics = this.metrics().stream().map(metric -> ResponseSchemaEntry.metric(metric.functionName(), metric.fieldName()));
        return Stream.concat(groupings, metrics).collect(Collectors.toList());
    }
}

