/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchfilters.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.graph.MutableGraph;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.searchfilters.model.AutoValue_ReferencedQueryStringSearchFilter;
import org.graylog.plugins.views.search.searchfilters.model.DBSearchFilter;
import org.graylog.plugins.views.search.searchfilters.model.InlineQueryStringSearchFilter;
import org.graylog.plugins.views.search.searchfilters.model.QueryStringSearchFilter;
import org.graylog.plugins.views.search.searchfilters.model.ReferencedSearchFilter;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

@JsonTypeName(value="referenced")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ReferencedQueryStringSearchFilter
implements ReferencedSearchFilter,
QueryStringSearchFilter {
    @Override
    @JsonProperty(value="id")
    public abstract String id();

    @JsonProperty(value="title")
    @Nullable
    public abstract String title();

    @JsonProperty(value="description")
    @Nullable
    public abstract String description();

    @Override
    @JsonProperty(value="queryString")
    @Nullable
    public abstract String queryString();

    @Override
    @JsonProperty(value="negation", defaultValue="false")
    public abstract boolean negation();

    @Override
    @JsonProperty(value="disabled", defaultValue="false")
    public abstract boolean disabled();

    public static ReferencedQueryStringSearchFilter create(String id) {
        return ReferencedQueryStringSearchFilter.builder().id(id).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    public UsedSearchFilter withQueryString(String queryString) {
        return this.toBuilder().queryString(queryString).build();
    }

    @Override
    public InlineQueryStringSearchFilter toInlineRepresentation() {
        return InlineQueryStringSearchFilter.builder().queryString(this.queryString()).description(this.description()).negation(this.negation()).title(this.title()).disabled(this.disabled()).build();
    }

    @Override
    public ReferencedSearchFilter withId(String id) {
        return this.toBuilder().id(id).build();
    }

    @Override
    public UsedSearchFilter toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        DBSearchFilter dbFilter = (DBSearchFilter)nativeEntities.get(EntityDescriptor.create(this.id(), ModelTypes.SEARCH_FILTER_V1));
        if (dbFilter != null) {
            return this.withId(dbFilter.id());
        }
        return this.toInlineRepresentation();
    }

    @Override
    public UsedSearchFilter toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        Optional<String> entityId = entityDescriptorIds.get(EntityDescriptor.create(this.id(), ModelTypes.SEARCH_FILTER_V1));
        if (entityId.isPresent()) {
            return this.withId(entityId.get());
        }
        return this;
    }

    @Override
    public void resolveNativeEntity(EntityDescriptor entityDescriptor, MutableGraph<EntityDescriptor> mutableGraph) {
        mutableGraph.putEdge((Object)entityDescriptor, (Object)EntityDescriptor.create(this.id(), ModelTypes.SEARCH_FILTER_V1));
    }

    @Override
    public void resolveForInstallation(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities, MutableGraph<Entity> graph) {
        Entity filterEntity = entities.get(EntityDescriptor.create(this.id(), ModelTypes.SEARCH_FILTER_V1));
        if (filterEntity != null) {
            graph.putEdge((Object)entity, (Object)filterEntity);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder id(String var1);

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="description")
        public abstract Builder description(String var1);

        @JsonProperty(value="queryString")
        public abstract Builder queryString(String var1);

        @JsonProperty(value="negation", defaultValue="false")
        public abstract Builder negation(boolean var1);

        @JsonProperty(value="disabled", defaultValue="false")
        public abstract Builder disabled(boolean var1);

        @JsonCreator
        public static Builder create() {
            return new AutoValue_ReferencedQueryStringSearchFilter.Builder().disabled(false).negation(false);
        }

        public abstract ReferencedQueryStringSearchFilter build();
    }
}

