/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.pivot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.MutableGraph;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.SearchTypeBuilder;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.rest.SearchTypeExecutionState;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.searchtypes.pivot.AutoValue_Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.PivotEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonTypeName(value="pivot")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Pivot
implements SearchType {
    public static final String NAME = "pivot";

    @Override
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @JsonProperty
    public abstract Optional<String> name();

    @JsonProperty(value="row_groups")
    public abstract List<BucketSpec> rowGroups();

    @JsonProperty(value="column_groups")
    public abstract List<BucketSpec> columnGroups();

    @JsonProperty
    public abstract List<SeriesSpec> series();

    @JsonProperty
    public abstract List<SortSpec> sort();

    @JsonProperty
    public abstract boolean rollup();

    @Override
    @Nullable
    public abstract Filter filter();

    @Override
    @JsonProperty(value="filters")
    public abstract List<UsedSearchFilter> filters();

    @Override
    public abstract Builder toBuilder();

    @Override
    public SearchType applyExecutionContext(SearchTypeExecutionState state) {
        return this;
    }

    public static Builder builder() {
        return ((Builder)new AutoValue_Pivot.Builder().type(NAME).rowGroups((List<BucketSpec>)ImmutableList.of()).columnGroups((List<BucketSpec>)ImmutableList.of()).sort((List<SortSpec>)ImmutableList.of()).filters((List)ImmutableList.of())).streamCategories(Collections.emptySet()).streams(Collections.emptySet());
    }

    @Override
    public SearchTypeEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        PivotEntity.Builder builder = ((PivotEntity.Builder)((PivotEntity.Builder)PivotEntity.builder().sort(this.sort()).streams((Set)this.mappedStreams(entityDescriptorIds))).streamCategories((Set)this.streamCategories())).timerange((DerivedTimeRange)this.timerange().orElse(null)).columnGroups(this.columnGroups()).rowGroups(this.rowGroups()).filter(this.filter()).filters(this.filters().stream().map(filter -> filter.toContentPackEntity(entityDescriptorIds)).toList()).query(this.query().orElse(null)).id(this.id()).name(this.name().orElse(null)).rollup(this.rollup()).series(this.series()).type(this.type());
        return builder.build();
    }

    @Override
    public void resolveNativeEntity(EntityDescriptor entityDescriptor, MutableGraph<EntityDescriptor> mutableGraph) {
        this.filters().forEach(filter -> filter.resolveNativeEntity(entityDescriptor, mutableGraph));
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements SearchTypeBuilder {
        @JsonCreator
        public static Builder createDefault() {
            return ((Builder)Pivot.builder().sort(Collections.emptyList()).filters(Collections.emptyList())).streamCategories(Collections.emptySet()).streams(Collections.emptySet());
        }

        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        abstract String id();

        @JsonProperty
        public abstract Builder name(@Nullable String var1);

        @JsonProperty(value="row_groups")
        public abstract Builder rowGroups(List<BucketSpec> var1);

        public Builder rowGroups(BucketSpec ... rowGroups) {
            return this.rowGroups(List.of(rowGroups));
        }

        @JsonProperty(value="column_groups")
        public abstract Builder columnGroups(List<BucketSpec> var1);

        public Builder columnGroups(BucketSpec ... columnGroups) {
            return this.columnGroups(List.of(columnGroups));
        }

        @JsonProperty
        public abstract Builder series(List<SeriesSpec> var1);

        public Builder series(SeriesSpec ... series) {
            return this.series(List.of(series));
        }

        @JsonProperty
        public abstract Builder sort(List<SortSpec> var1);

        public Builder sort(SortSpec ... sort) {
            return this.sort(List.of(sort));
        }

        @JsonProperty
        public abstract Builder rollup(boolean var1);

        @Override
        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @Override
        @JsonProperty(value="filters")
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty
        public Builder timerange(@Nullable TimeRange timerange) {
            return this.timerange(timerange == null ? null : DerivedTimeRange.of(timerange));
        }

        @Override
        public abstract Builder timerange(@Nullable DerivedTimeRange var1);

        @Override
        @JsonProperty
        public abstract Builder query(@Nullable BackendQuery var1);

        @Override
        @JsonProperty
        public abstract Builder streams(Set<String> var1);

        @JsonProperty
        public abstract Builder streamCategories(@Nullable Set<String> var1);

        abstract Pivot autoBuild();

        @Override
        public Pivot build() {
            if (this.id() == null) {
                this.id(UUID.randomUUID().toString());
            }
            return this.autoBuild();
        }
    }
}

