/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.google.common.base.Functions;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.db.SearchDbService;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewParameterSummaryDTO;
import org.graylog.plugins.views.search.views.ViewService;

public class QualifyingViewsService {
    private final SearchDbService searchDbService;
    private final ViewService viewService;

    @Inject
    public QualifyingViewsService(SearchDbService searchDbService, ViewService viewService) {
        this.searchDbService = searchDbService;
        this.viewService = viewService;
    }

    public Collection<ViewParameterSummaryDTO> forValue() {
        Set<String> searches = this.viewService.streamAll().map(ViewDTO::searchId).collect(Collectors.toSet());
        Map qualifyingSearches = this.searchDbService.findByIds(searches).stream().filter(search -> !search.parameters().isEmpty()).collect(Collectors.toMap(Search::id, Functions.identity()));
        return this.viewService.streamAll().filter(view -> qualifyingSearches.keySet().contains(view.searchId())).map(view -> ViewParameterSummaryDTO.create(view, (Search)qualifyingSearches.get(view.searchId()))).collect(Collectors.toSet());
    }
}

