/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mongodb.DuplicateKeyException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.InsertOneResult;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog.plugins.views.search.views.ViewClusterConfig;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewRequirements;
import org.graylog.plugins.views.search.views.ViewSummaryDTO;
import org.graylog.plugins.views.search.views.ViewSummaryService;
import org.graylog.plugins.views.search.views.ViewUtils;
import org.graylog.security.entities.EntityOwnershipService;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.indices.MongoDbIndexTools;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.SortOrder;
import org.graylog2.search.SearchQuery;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ViewService
implements ViewUtils<ViewDTO> {
    private static final String COLLECTION_NAME = "views";
    private final ClusterConfigService clusterConfigService;
    private final ViewRequirements.Factory viewRequirementsFactory;
    private final EntityOwnershipService entityOwnerShipService;
    private final ViewSummaryService viewSummaryService;
    private final MongoCollection<ViewDTO> collection;
    private final MongoPaginationHelper<ViewDTO> pagination;
    private final MongoUtils<ViewDTO> mongoUtils;

    @Inject
    protected ViewService(ClusterConfigService clusterConfigService, ViewRequirements.Factory viewRequirementsFactory, EntityOwnershipService entityOwnerShipService, ViewSummaryService viewSummaryService, MongoCollections mongoCollections) {
        this.clusterConfigService = clusterConfigService;
        this.viewRequirementsFactory = viewRequirementsFactory;
        this.entityOwnerShipService = entityOwnerShipService;
        this.viewSummaryService = viewSummaryService;
        this.collection = mongoCollections.collection(COLLECTION_NAME, ViewDTO.class);
        this.pagination = mongoCollections.paginationHelper(this.collection);
        this.mongoUtils = mongoCollections.utils(this.collection);
        new MongoDbIndexTools<ViewDTO>(this.collection).prepareIndices("id", (Collection<String>)ViewDTO.SORT_FIELDS, (Collection<String>)ViewDTO.STRING_SORT_FIELDS);
    }

    private PaginatedList<ViewDTO> searchPaginated(SearchUser searchUser, SearchQuery query, Predicate<ViewDTO> filter, SortOrder order, String sortField, Bson grandTotalQuery, int page, int perPage) {
        PaginatedList<ViewDTO> viewsList = this.findPaginatedWithQueryFilterAndSortWithGrandTotal(searchUser, query, filter, Sorts.orderBy((Bson[])new Bson[]{order.toBsonSort(sortField), order.toBsonSort("title")}), grandTotalQuery, page, perPage);
        return viewsList.withList(viewsList.delegate().stream().map(this::requirementsForView).toList());
    }

    public Optional<ViewDTO> get(SearchUser searchUser, String id) {
        return this.findViews(searchUser, Filters.eq((String)"_id", (Object)new ObjectId(id)), Sorts.ascending((String[])new String[]{"_id"})).findFirst();
    }

    protected PaginatedList<ViewDTO> findPaginatedWithQueryFilterAndSortWithGrandTotal(SearchUser searchUser, SearchQuery dbQuery, Predicate<ViewDTO> filter, Bson sort, Bson grandTotalQuery, int page, int perPage) {
        long grandTotal = this.collection.countDocuments(grandTotalQuery);
        List<ViewDTO> views = this.findViews(searchUser, dbQuery.toBson(), sort).filter(filter).toList();
        List<ViewDTO> paginatedStreams = perPage > 0 ? views.stream().skip((long)perPage * (long)Math.max(0, page - 1)).limit(perPage).toList() : views;
        return new PaginatedList<ViewDTO>(paginatedStreams, views.size(), page, perPage, grandTotal);
    }

    public PaginatedList<ViewDTO> searchPaginated(SearchUser searchUser, SearchQuery query, Predicate<ViewDTO> filter, SortOrder order, String sortField, int page, int perPage) {
        return this.searchPaginated(searchUser, query, filter, order, sortField, (Bson)new BsonDocument(), page, perPage);
    }

    private PaginatedList<ViewDTO> searchPaginatedWithGrandTotal(Bson query, Predicate<ViewDTO> filter, SortOrder order, String sortField, Bson grandTotalQuery, int page, int perPage) {
        return this.pagination.perPage(perPage).sort(order.toBsonSort(sortField)).filter(query).includeGrandTotal(true).grandTotalFilter(grandTotalQuery).page(page, filter);
    }

    public PaginatedList<ViewDTO> searchPaginatedByType(ViewDTO.Type type, SearchQuery query, Predicate<ViewDTO> filter, SortOrder order, String sortField, int page, int perPage) {
        Preconditions.checkNotNull((Object)sortField);
        return this.searchPaginatedWithGrandTotal(Filters.and((Bson[])new Bson[]{Filters.or((Bson[])new Bson[]{Filters.eq((String)"type", (Object)((Object)type)), Filters.not((Bson)Filters.exists((String)"type"))}), query.toBson()}), filter, order, sortField, Filters.or((Bson[])new Bson[]{Filters.eq((String)"type", (Object)((Object)type)), Filters.not((Bson)Filters.exists((String)"type"))}), page, perPage);
    }

    public PaginatedList<ViewSummaryDTO> searchSummariesPaginatedByType(SearchUser searchUser, ViewDTO.Type type, Bson dbQuery, Predicate<ViewSummaryDTO> predicate, SortOrder order, String sortField, int page, int perPage) {
        return this.viewSummaryService.searchPaginatedByType(searchUser, type, dbQuery, predicate, order, sortField, page, perPage);
    }

    public void saveDefault(ViewDTO dto) {
        if (Strings.isNullOrEmpty((String)dto.id())) {
            throw new IllegalArgumentException("ViewDTO needs an ID to be configured as default view");
        }
        this.clusterConfigService.write(ViewClusterConfig.builder().defaultViewId(dto.id()).build());
    }

    public Optional<ViewDTO> getDefault() {
        return Optional.ofNullable(this.clusterConfigService.get(ViewClusterConfig.class)).flatMap(config -> this.get(config.defaultViewId()));
    }

    public Collection<ViewDTO> forSearch(String searchId) {
        return MongoUtils.stream(this.collection.find(Filters.eq((String)"search_id", (Object)searchId))).map(this::requirementsForView).collect(Collectors.toSet());
    }

    public Optional<ViewDTO> get(String id) {
        return this.mongoUtils.getById(id).map(this::requirementsForView);
    }

    public Stream<ViewDTO> streamAll() {
        return MongoUtils.stream(this.collection.find()).map(this::requirementsForView);
    }

    public Stream<ViewDTO> streamByIds(Set<String> idSet) {
        return MongoUtils.stream(this.collection.find(MongoUtils.stringIdsIn(idSet))).map(this::requirementsForView);
    }

    public ViewDTO saveWithOwner(ViewDTO viewDTO, User user) {
        ViewDTO savedObject = this.save(viewDTO);
        if (viewDTO.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
            this.entityOwnerShipService.registerNewDashboard(savedObject.id(), user);
        } else {
            this.entityOwnerShipService.registerNewSearch(savedObject.id(), user);
        }
        return savedObject;
    }

    public ViewDTO save(ViewDTO viewDTO) {
        try {
            InsertOneResult save = this.collection.insertOne((Object)this.requirementsForView(viewDTO));
            return this.mongoUtils.getById(MongoUtils.insertedId(save)).orElseThrow(() -> new IllegalStateException("Unable to retrieve saved View!"));
        }
        catch (DuplicateKeyException e) {
            throw new IllegalStateException("Unable to save view, it already exists.");
        }
    }

    public void delete(String id) {
        this.get(id).ifPresent(view -> {
            if (view.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
                this.entityOwnerShipService.unregisterDashboard(id);
            } else {
                this.entityOwnerShipService.unregisterSearch(id);
            }
        });
        this.mongoUtils.deleteById(id);
    }

    public ViewDTO update(ViewDTO viewDTO) {
        Preconditions.checkArgument((viewDTO.id() != null ? 1 : 0) != 0, (Object)"Id of view must not be null.");
        ViewDTO viewWithRequirements = this.requirementsForView(viewDTO).toBuilder().lastUpdatedAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).build();
        this.collection.replaceOne(MongoUtils.idEq(viewWithRequirements.id()), (Object)viewWithRequirements);
        return viewWithRequirements;
    }

    public ViewDTO requirementsForView(ViewDTO view) {
        return this.viewRequirementsFactory.create(view).rebuildRequirements(ViewDTO::requires, (v, newRequirements) -> v.toBuilder().requires((Map<String, PluginMetadataSummary>)newRequirements).build());
    }

    @Override
    public MongoCollection<ViewDTO> collection() {
        return this.collection;
    }
}

