/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.startpage;

import com.google.common.eventbus.EventBus;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.startpage.lastOpened.LastOpened;
import org.graylog.plugins.views.startpage.lastOpened.LastOpenedDTO;
import org.graylog.plugins.views.startpage.lastOpened.LastOpenedForUserDTO;
import org.graylog.plugins.views.startpage.lastOpened.LastOpenedService;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivity;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityDTO;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityService;
import org.graylog.plugins.views.startpage.title.StartPageItemTitleRetriever;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.models.PaginatedResponse;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class StartPageService {
    private final GRNRegistry grnRegistry;
    private final LastOpenedService lastOpenedService;
    private final RecentActivityService recentActivityService;
    private final StartPageItemTitleRetriever startPageItemTitleRetriever;
    private final long MAXIMUM_LAST_OPENED_PER_USER = 100L;

    @Inject
    public StartPageService(GRNRegistry grnRegistry, LastOpenedService lastOpenedService, RecentActivityService recentActivityService, EventBus eventBus, StartPageItemTitleRetriever startPageItemTitleRetriever) {
        this.grnRegistry = grnRegistry;
        this.lastOpenedService = lastOpenedService;
        this.recentActivityService = recentActivityService;
        this.startPageItemTitleRetriever = startPageItemTitleRetriever;
        eventBus.register((Object)this);
    }

    public PaginatedResponse<LastOpened> findLastOpenedFor(SearchUser searchUser, int page, int perPage) {
        if (perPage <= 0 || page <= 0) {
            throw new IllegalArgumentException("invalid page size: " + perPage);
        }
        List items = this.lastOpenedService.findForUser(searchUser).orElse(new LastOpenedForUserDTO(searchUser.getUser().getId(), List.of())).items().stream().skip((long)(page - 1) * (long)perPage).map(i -> this.startPageItemTitleRetriever.retrieveTitle(i.grn(), searchUser).map(title -> new LastOpened(i.grn(), (String)title, i.timestamp()))).flatMap(Optional::stream).limit(perPage).toList();
        return PaginatedResponse.create("lastOpened", new PaginatedList(items, items.size(), page, perPage));
    }

    public PaginatedResponse<RecentActivity> findRecentActivityFor(SearchUser searchUser, int page, int perPage) {
        PaginatedList<RecentActivityDTO> items = this.recentActivityService.findRecentActivitiesFor(searchUser, page, perPage);
        List<RecentActivity> mapped = items.stream().map(i -> this.startPageItemTitleRetriever.retrieveTitle(i.itemGrn(), searchUser).map(title -> new RecentActivity(i.id(), i.activityType(), i.itemGrn(), (String)title, i.userName(), i.timestamp())).orElse(new RecentActivity(i.id(), i.activityType(), i.itemGrn(), i.itemTitle(), i.userName(), i.timestamp()))).toList();
        return PaginatedResponse.create("recentActivity", new PaginatedList<RecentActivity>(mapped, items.pagination().total(), page, perPage));
    }

    protected static List<LastOpenedDTO> filterForExistingIdAndCapAtMaximum(LastOpenedForUserDTO loi, GRN grn, long max) {
        return loi.items().stream().filter(i -> !i.grn().equals(grn)).limit(max - 1L).toList();
    }

    public void addLastOpenedFor(ViewDTO view, SearchUser searchUser) {
        GRNType type = view.type().equals((Object)ViewDTO.Type.DASHBOARD) ? GRNTypes.DASHBOARD : GRNTypes.SEARCH;
        Optional<LastOpenedForUserDTO> lastOpenedItems = this.lastOpenedService.findForUser(searchUser);
        LastOpenedDTO item = new LastOpenedDTO(this.grnRegistry.newGRN(type, view.id()), DateTime.now((DateTimeZone)DateTimeZone.UTC));
        if (lastOpenedItems.isPresent()) {
            LastOpenedForUserDTO loi = lastOpenedItems.get();
            List<LastOpenedDTO> items = StartPageService.filterForExistingIdAndCapAtMaximum(loi, item.grn(), 100L);
            loi.items().clear();
            loi.items().add(item);
            loi.items().addAll(items);
            this.lastOpenedService.save(loi);
        } else {
            LastOpenedForUserDTO items = new LastOpenedForUserDTO(searchUser.getUser().getId(), List.of(item));
            this.lastOpenedService.create(items);
        }
    }
}

