/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.startpage.lastOpened;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mongodb.DuplicateKeyException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import java.util.Optional;
import org.bson.conversions.Bson;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.startpage.lastOpened.LastOpenedForUserDTO;
import org.graylog.plugins.views.startpage.recentActivities.ActivityType;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityEvent;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.users.events.UserDeletedEvent;

public class LastOpenedService {
    public static final String COLLECTION_NAME = "last_opened";
    private final MongoCollection<LastOpenedForUserDTO> db;

    @Inject
    public LastOpenedService(MongoCollections mongoCollections, EventBus eventBus) {
        this.db = mongoCollections.collection(COLLECTION_NAME, LastOpenedForUserDTO.class);
        eventBus.register((Object)this);
        this.db.createIndex(Indexes.ascending((String[])new String[]{"user_id"}));
        this.db.createIndex(Indexes.ascending((String[])new String[]{"items.grn"}));
    }

    public Optional<LastOpenedForUserDTO> findForUser(SearchUser searchUser) {
        return this.findForUser(searchUser.getUser().getId());
    }

    Optional<LastOpenedForUserDTO> findForUser(String userId) {
        return MongoUtils.stream(this.db.find(Filters.eq((String)"user_id", (Object)userId))).findAny();
    }

    public void create(LastOpenedForUserDTO lastOpenedItems) {
        try {
            this.db.insertOne((Object)lastOpenedItems);
        }
        catch (DuplicateKeyException e) {
            throw new IllegalStateException("Unable to create a last opened collection, collection with this id already exists : " + lastOpenedItems.id());
        }
    }

    @Subscribe
    public void removeLastOpenedOnEntityDeletion(RecentActivityEvent event) {
        if (event.activityType().equals((Object)ActivityType.DELETE)) {
            String grn = event.grn().toString();
            Bson query = Filters.eq((String)"items.grn", (Object)grn);
            Bson modifications = Updates.pull((String)"items", (Object)Filters.eq((String)"grn", (Object)grn));
            this.db.updateMany(query, modifications);
        }
    }

    @Subscribe
    public void removeFavoriteEntityOnUserDeletion(UserDeletedEvent event) {
        this.db.deleteMany(Filters.eq((String)"user_id", (Object)event.userId()));
    }

    public void save(LastOpenedForUserDTO loi) {
        if (loi.id() == null) {
            this.create(loi);
        } else {
            this.db.replaceOne(MongoUtils.idEq(loi.id()), (Object)loi);
        }
    }

    @VisibleForTesting
    long count() {
        return this.db.countDocuments();
    }
}

