/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.startpage.recentActivities;

import com.google.common.eventbus.EventBus;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.Filters;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.List;
import org.bson.conversions.Bson;
import org.graylog.grn.GRN;
import org.graylog.grn.GRNRegistry;
import org.graylog.grn.GRNType;
import org.graylog.grn.GRNTypes;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.startpage.recentActivities.ActivityType;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityDTO;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivityEvent;
import org.graylog.security.PermissionAndRoleResolver;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.SortOrder;

public class RecentActivityService {
    public static final String COLLECTION_NAME = "recent_activity";
    private final EventBus eventBus;
    private final GRNRegistry grnRegistry;
    private final PermissionAndRoleResolver permissionAndRoleResolver;
    private static final long MAXIMUM_RECENT_ACTIVITIES = 10000L;
    private final MongoCollection<RecentActivityDTO> db;
    private final MongoPaginationHelper<RecentActivityDTO> pagination;

    @Inject
    public RecentActivityService(MongoCollections mongoCollections, MongoConnection mongoConnection, EventBus eventBus, GRNRegistry grnRegistry, PermissionAndRoleResolver permissionAndRoleResolver) {
        this(mongoCollections, mongoConnection, eventBus, grnRegistry, permissionAndRoleResolver, 10000L);
    }

    protected RecentActivityService(MongoCollections mongoCollections, MongoConnection mongoConnection, EventBus eventBus, GRNRegistry grnRegistry, PermissionAndRoleResolver permissionAndRoleResolver, long maximum) {
        MongoDatabase mongodb = mongoConnection.getMongoDatabase();
        if (!((HashSet)mongodb.listCollectionNames().into(new HashSet())).contains(COLLECTION_NAME)) {
            mongodb.createCollection(COLLECTION_NAME, new CreateCollectionOptions().capped(true).sizeInBytes(maximum * 1024L).maxDocuments(maximum));
        }
        this.db = mongoCollections.collection(COLLECTION_NAME, RecentActivityDTO.class);
        this.grnRegistry = grnRegistry;
        this.permissionAndRoleResolver = permissionAndRoleResolver;
        this.eventBus = eventBus;
        this.pagination = mongoCollections.paginationHelper(this.db);
        this.db.createIndex((Bson)new BasicDBObject("item_grn", (Object)1));
    }

    private void postRecentActivity(RecentActivityEvent event) {
        this.eventBus.post((Object)event);
    }

    public void create(String id, GRNType grn, SearchUser user) {
        this.create(id, grn, user.getUser());
    }

    public void create(String id, GRNType grn, User user) {
        this.postRecentActivity(new RecentActivityEvent(ActivityType.CREATE, this.grnRegistry.newGRN(grn, id), user.getFullName()));
    }

    public void update(String id, GRNType grn, SearchUser user) {
        this.update(id, grn, user.getUser());
    }

    public void update(String id, GRNType grn, User user) {
        this.postRecentActivity(new RecentActivityEvent(ActivityType.UPDATE, this.grnRegistry.newGRN(grn, id), user.getFullName()));
    }

    public void delete(String id, GRNType grn, String title, SearchUser user) {
        this.delete(id, grn, title, user.getUser());
    }

    public void delete(String id, GRNType grn, String title, User user) {
        this.postRecentActivity(new RecentActivityEvent(ActivityType.DELETE, this.grnRegistry.newGRN(grn, id), title, user.getFullName()));
    }

    public PaginatedList<RecentActivityDTO> findRecentActivitiesFor(SearchUser user, int page, int perPage) {
        Bson sort = SortOrder.DESCENDING.toBsonSort("timestamp");
        if (user.getUser().isLocalAdmin()) {
            return this.pagination.perPage(perPage).sort(sort).includeGrandTotal(true).page(page);
        }
        GRN principal = this.grnRegistry.newGRN(GRNTypes.USER, user.getUser().getId());
        List<String> grns = this.permissionAndRoleResolver.resolveGrantees(principal).stream().map(GRN::toString).toList();
        Bson query = Filters.in((String)"grantee", grns);
        return this.pagination.perPage(perPage).sort(sort).filter(query).includeGrandTotal(true).grandTotalFilter(query).page(page);
    }

    public void deleteAllEntriesForEntity(GRN grn) {
        this.db.deleteMany(Filters.eq((String)"item_grn", (Object)grn.toString()));
    }

    public void save(RecentActivityDTO activity) {
        this.db.insertOne((Object)activity);
    }
}

