/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.machine;

import com.google.common.util.concurrent.AbstractIdleService;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationState;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachine;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.datanode.CurrentWriteIndices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationShutdownService
extends AbstractIdleService {
    private final Logger log = LoggerFactory.getLogger(AbstractIdleService.class);
    private final MigrationStateMachine migrationStateMachine;
    private final IndexSetRegistry indexSetRegistry;

    @Inject
    public MigrationShutdownService(MigrationStateMachine migrationStateMachine, IndexSetRegistry indexSetRegistry) {
        this.migrationStateMachine = migrationStateMachine;
        this.indexSetRegistry = indexSetRegistry;
    }

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        if (List.of(MigrationState.EXISTING_DATA_MIGRATION_QUESTION_PAGE, MigrationState.MIGRATE_EXISTING_DATA, MigrationState.REMOTE_REINDEX_RUNNING).contains((Object)this.migrationStateMachine.getState())) {
            this.log.info("Storing active write indices for data node migration");
            Map<String, String> indices = this.indexSetRegistry.getAll().stream().filter(indexSet -> indexSet.isUp() && indexSet.getConfig().isWritable() && Objects.nonNull(indexSet.getActiveWriteIndex())).collect(Collectors.toMap(is -> is.getConfig().id(), IndexSet::getActiveWriteIndex));
            this.migrationStateMachine.getContext().addExtendedState("indexSetWriteIndices", new CurrentWriteIndices(indices));
            this.migrationStateMachine.saveContext();
        }
    }
}

