/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.machine;

import com.github.oxo42.stateless4j.StateMachine;
import com.github.oxo42.stateless4j.StateMachineConfig;
import com.github.oxo42.stateless4j.delegates.Action1;
import com.github.oxo42.stateless4j.delegates.Func;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import org.graylog.plugins.views.storage.migration.state.actions.MigrationActions;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationState;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStep;
import org.graylog.plugins.views.storage.migration.state.persistence.DatanodeMigrationConfiguration;
import org.graylog.plugins.views.storage.migration.state.persistence.DatanodeMigrationPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationStateMachineBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationStateMachineBuilder.class);

    @Nonnull
    private static StateMachineConfig<MigrationState, MigrationStep> configureStates(MigrationActions migrationActions) {
        StateMachineConfig config = new StateMachineConfig();
        config.configure((Object)MigrationState.NEW).permit((Object)MigrationStep.SELECT_MIGRATION, (Object)MigrationState.MIGRATION_WELCOME_PAGE, () -> LOG.info("Migration selected in menu, show welcome page"));
        config.configure((Object)MigrationState.MIGRATION_WELCOME_PAGE).permitIf((Object)MigrationStep.SHOW_CA_CREATION, (Object)MigrationState.CA_CREATION_PAGE, () -> (migrationActions.isRemoteReindexMigrationEnabled() || migrationActions.isCompatibleInPlaceMigrationVersion()) && migrationActions.caDoesNotExist()).permitIf((Object)MigrationStep.SHOW_RENEWAL_POLICY_CREATION, (Object)MigrationState.RENEWAL_POLICY_CREATION_PAGE, () -> {
            if (!migrationActions.isRemoteReindexMigrationEnabled() && !migrationActions.isCompatibleInPlaceMigrationVersion()) {
                return false;
            }
            return !migrationActions.caDoesNotExist() && migrationActions.renewalPolicyDoesNotExist();
        }).permitIf((Object)MigrationStep.SHOW_MIGRATION_SELECTION, (Object)MigrationState.MIGRATION_SELECTION_PAGE, () -> {
            if (!migrationActions.isRemoteReindexMigrationEnabled()) {
                return false;
            }
            return migrationActions.caAndRenewalPolicyExist() && migrationActions.isCompatibleInPlaceMigrationVersion();
        }).permitIf((Object)MigrationStep.SELECT_REMOTE_REINDEX_MIGRATION, (Object)MigrationState.REMOTE_REINDEX_WELCOME_PAGE, () -> {
            if (!migrationActions.isRemoteReindexMigrationEnabled() && !migrationActions.isCompatibleInPlaceMigrationVersion()) {
                return false;
            }
            return migrationActions.caAndRenewalPolicyExist() && !migrationActions.isCompatibleInPlaceMigrationVersion();
        }).permitIf((Object)MigrationStep.SELECT_ROLLING_UPGRADE_MIGRATION, (Object)MigrationState.ROLLING_UPGRADE_MIGRATION_WELCOME_PAGE, () -> !migrationActions.isRemoteReindexMigrationEnabled() && migrationActions.caAndRenewalPolicyExist());
        config.configure((Object)MigrationState.CA_CREATION_PAGE).permitIf((Object)MigrationStep.SHOW_RENEWAL_POLICY_CREATION, (Object)MigrationState.RENEWAL_POLICY_CREATION_PAGE, () -> !migrationActions.caDoesNotExist() && migrationActions.renewalPolicyDoesNotExist()).permitIf((Object)MigrationStep.SHOW_MIGRATION_SELECTION, (Object)MigrationState.MIGRATION_SELECTION_PAGE, () -> migrationActions.caAndRenewalPolicyExist() && migrationActions.isCompatibleInPlaceMigrationVersion() && migrationActions.isRemoteReindexMigrationEnabled()).permitIf((Object)MigrationStep.SELECT_REMOTE_REINDEX_MIGRATION, (Object)MigrationState.REMOTE_REINDEX_WELCOME_PAGE, () -> migrationActions.caAndRenewalPolicyExist() && !migrationActions.isCompatibleInPlaceMigrationVersion()).permitIf((Object)MigrationStep.SELECT_ROLLING_UPGRADE_MIGRATION, (Object)MigrationState.ROLLING_UPGRADE_MIGRATION_WELCOME_PAGE, () -> !migrationActions.isRemoteReindexMigrationEnabled() && migrationActions.caAndRenewalPolicyExist());
        config.configure((Object)MigrationState.RENEWAL_POLICY_CREATION_PAGE).permitIf((Object)MigrationStep.SHOW_MIGRATION_SELECTION, (Object)MigrationState.MIGRATION_SELECTION_PAGE, () -> migrationActions.caAndRenewalPolicyExist() && migrationActions.isCompatibleInPlaceMigrationVersion() && migrationActions.isRemoteReindexMigrationEnabled()).permitIf((Object)MigrationStep.SELECT_REMOTE_REINDEX_MIGRATION, (Object)MigrationState.REMOTE_REINDEX_WELCOME_PAGE, () -> migrationActions.caAndRenewalPolicyExist() && !migrationActions.isCompatibleInPlaceMigrationVersion()).permitIf((Object)MigrationStep.SELECT_ROLLING_UPGRADE_MIGRATION, (Object)MigrationState.ROLLING_UPGRADE_MIGRATION_WELCOME_PAGE, () -> !migrationActions.isRemoteReindexMigrationEnabled() && migrationActions.caAndRenewalPolicyExist());
        config.configure((Object)MigrationState.MIGRATION_SELECTION_PAGE).permitIf((Object)MigrationStep.SELECT_ROLLING_UPGRADE_MIGRATION, (Object)MigrationState.ROLLING_UPGRADE_MIGRATION_WELCOME_PAGE, migrationActions::isCompatibleInPlaceMigrationVersion).permitIf((Object)MigrationStep.SELECT_REMOTE_REINDEX_MIGRATION, (Object)MigrationState.REMOTE_REINDEX_WELCOME_PAGE, migrationActions::isRemoteReindexMigrationEnabled);
        config.configure((Object)MigrationState.REMOTE_REINDEX_WELCOME_PAGE).onEntry(migrationActions::reindexUpgradeSelected).permitIf((Object)MigrationStep.PROVISION_DATANODE_CERTIFICATES, (Object)MigrationState.PROVISION_DATANODE_CERTIFICATES_RUNNING, () -> !migrationActions.allDatanodesAvailable() && migrationActions.compatibleDatanodesRunning(), migrationActions::provisionAndStartDataNodes).permitIf((Object)MigrationStep.SHOW_DATA_MIGRATION_QUESTION, (Object)MigrationState.EXISTING_DATA_MIGRATION_QUESTION_PAGE, migrationActions::allDatanodesAvailable).onExit(migrationActions::setPreflightFinished);
        config.configure((Object)MigrationState.PROVISION_DATANODE_CERTIFICATES_RUNNING).permitIf((Object)MigrationStep.SHOW_DATA_MIGRATION_QUESTION, (Object)MigrationState.EXISTING_DATA_MIGRATION_QUESTION_PAGE, migrationActions::allDatanodesAvailable);
        config.configure((Object)MigrationState.EXISTING_DATA_MIGRATION_QUESTION_PAGE).permit((Object)MigrationStep.SHOW_MIGRATE_EXISTING_DATA, (Object)MigrationState.MIGRATE_EXISTING_DATA, migrationActions::getElasticsearchHosts).permit((Object)MigrationStep.SKIP_EXISTING_DATA_MIGRATION, (Object)MigrationState.ASK_TO_SHUTDOWN_OLD_CLUSTER);
        config.configure((Object)MigrationState.MIGRATE_EXISTING_DATA).permitReentry((Object)MigrationStep.CHECK_REMOTE_INDEXER_CONNECTION, migrationActions::verifyRemoteIndexerConnection).permit((Object)MigrationStep.START_REMOTE_REINDEX_MIGRATION, (Object)MigrationState.REMOTE_REINDEX_RUNNING, migrationActions::startRemoteReindex);
        config.configure((Object)MigrationState.REMOTE_REINDEX_RUNNING).permitReentry((Object)MigrationStep.REQUEST_MIGRATION_STATUS, migrationActions::requestMigrationStatus).permit((Object)MigrationStep.RETRY_MIGRATE_EXISTING_DATA, (Object)MigrationState.MIGRATE_EXISTING_DATA).permitIf((Object)MigrationStep.SHOW_ASK_TO_SHUTDOWN_OLD_CLUSTER, (Object)MigrationState.ASK_TO_SHUTDOWN_OLD_CLUSTER, migrationActions::isRemoteReindexingFinished);
        config.configure((Object)MigrationState.ASK_TO_SHUTDOWN_OLD_CLUSTER).permit((Object)MigrationStep.CONFIRM_OLD_CLUSTER_STOPPED, (Object)MigrationState.FINISHED, migrationActions::finishRemoteReindexMigration);
        config.configure((Object)MigrationState.ROLLING_UPGRADE_MIGRATION_WELCOME_PAGE).onEntry(migrationActions::rollingUpgradeSelected).permitIf((Object)MigrationStep.RUN_DIRECTORY_COMPATIBILITY_CHECK, (Object)MigrationState.DIRECTORY_COMPATIBILITY_CHECK_PAGE, migrationActions::compatibleDatanodesRunning, migrationActions::runDirectoryCompatibilityCheck);
        config.configure((Object)MigrationState.DIRECTORY_COMPATIBILITY_CHECK_PAGE).permitReentryIf((Object)MigrationStep.RUN_DIRECTORY_COMPATIBILITY_CHECK, () -> !migrationActions.directoryCompatibilityCheckOk(), migrationActions::runDirectoryCompatibilityCheck).permitIf((Object)MigrationStep.PROVISION_DATANODE_CERTIFICATES, (Object)MigrationState.PROVISION_ROLLING_UPGRADE_NODES_RUNNING, () -> migrationActions.directoryCompatibilityCheckOk() && !migrationActions.provisioningFinished(), migrationActions::provisionDataNodes).permitIf((Object)MigrationStep.CALCULATE_JOURNAL_SIZE, (Object)MigrationState.JOURNAL_SIZE_DOWNTIME_WARNING, () -> migrationActions.directoryCompatibilityCheckOk() && migrationActions.provisioningFinished());
        config.configure((Object)MigrationState.PROVISION_ROLLING_UPGRADE_NODES_RUNNING).permitIf((Object)MigrationStep.CALCULATE_JOURNAL_SIZE, (Object)MigrationState.JOURNAL_SIZE_DOWNTIME_WARNING, migrationActions::allDatanodesPrepared);
        config.configure((Object)MigrationState.JOURNAL_SIZE_DOWNTIME_WARNING).onEntry(migrationActions::calculateTrafficEstimate).onEntry(migrationActions::stopDatanodes).permit((Object)MigrationStep.SHOW_STOP_PROCESSING_PAGE, (Object)MigrationState.MESSAGE_PROCESSING_STOP, migrationActions::stopMessageProcessing);
        config.configure((Object)MigrationState.MESSAGE_PROCESSING_STOP).permitIf((Object)MigrationStep.SHOW_ROLLING_UPGRADE_ASK_TO_SHUTDOWN_OLD_CLUSTER, (Object)MigrationState.RESTART_GRAYLOG, migrationActions::isOldClusterStopped, migrationActions::startDataNodes);
        config.configure((Object)MigrationState.RESTART_GRAYLOG).onEntry(migrationActions::setPreflightFinished).permitIf((Object)MigrationStep.CONFIRM_OLD_CONNECTION_STRING_FROM_CONFIG_REMOVED_AND_GRAYLOG_RESTARTED, (Object)MigrationState.FINISHED, migrationActions::allDatanodesAvailable);
        return config;
    }

    @VisibleForTesting
    static StateMachine<MigrationState, MigrationStep> buildWithTestState(MigrationState state, MigrationActions migrationActions) {
        StateMachineConfig<MigrationState, MigrationStep> config = MigrationStateMachineBuilder.configureStates(migrationActions);
        return new StateMachine((Object)state, config);
    }

    public static StateMachine<MigrationState, MigrationStep> buildFromPersistedState(DatanodeMigrationPersistence persistence, MigrationActions migrationActions) {
        StateMachineConfig<MigrationState, MigrationStep> statesConfiguration = MigrationStateMachineBuilder.configureStates(migrationActions);
        Func readStateFunction = () -> persistence.getConfiguration().map(DatanodeMigrationConfiguration::currentState).orElse(MigrationState.NEW);
        Action1 writeStateFunction = currentState -> persistence.saveConfiguration(new DatanodeMigrationConfiguration((MigrationState)((Object)currentState)));
        return new StateMachine((Object)((MigrationState)((Object)readStateFunction.call())), readStateFunction, writeStateFunction, statesConfiguration);
    }
}

