/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.machine;

import com.github.oxo42.stateless4j.StateMachine;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import org.graylog.plugins.views.storage.migration.state.actions.MigrationActions;
import org.graylog.plugins.views.storage.migration.state.actions.MigrationActionsFactory;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationState;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachine;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachineBuilder;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachineContext;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachineImpl;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStep;
import org.graylog.plugins.views.storage.migration.state.persistence.DatanodeMigrationPersistence;

@Singleton
public class MigrationStateMachineProvider
implements Provider<MigrationStateMachine> {
    private final DatanodeMigrationPersistence persistenceService;
    private final MigrationActionsFactory migrationActionsFactory;

    @Inject
    public MigrationStateMachineProvider(DatanodeMigrationPersistence persistenceService, MigrationActionsFactory migrationActionsFactory) {
        this.persistenceService = persistenceService;
        this.migrationActionsFactory = migrationActionsFactory;
    }

    public MigrationStateMachine get() {
        MigrationStateMachineContext context = this.persistenceService.getStateMachineContext().orElseGet(MigrationStateMachineContext::new);
        MigrationActions migrationActions = this.migrationActionsFactory.create(context);
        StateMachine<MigrationState, MigrationStep> stateMachine = MigrationStateMachineBuilder.buildFromPersistedState(this.persistenceService, migrationActions);
        return new MigrationStateMachineImpl(stateMachine, this.persistenceService, context);
    }
}

