/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog.scheduler.JobTriggerStatus;
import org.graylog.scheduler.JobTriggerUpdate;
import org.graylog.scheduler.capabilities.SchedulerCapabilitiesService;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.plugin.system.NodeId;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.mongojack.DBQuery;
import org.mongojack.InitializationRequiredForTransformation;

public class DBJobTriggerService {
    public static final String COLLECTION_NAME = "scheduler_triggers";
    private static final String FIELD_ID = "_id";
    static final String FIELD_JOB_DEFINITION_ID = "job_definition_id";
    private static final String FIELD_LOCK_OWNER = "lock.owner";
    private static final String FIELD_LAST_LOCK_OWNER = "lock.last_owner";
    private static final String FIELD_PROGRESS = "lock.progress";
    private static final String FIELD_LAST_LOCK_TIME = "lock.last_lock_time";
    private static final String FIELD_NEXT_TIME = "next_time";
    private static final String FIELD_START_TIME = "start_time";
    private static final String FIELD_END_TIME = "end_time";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_SCHEDULE = "schedule";
    private static final String FIELD_DATA = "data";
    private static final String FIELD_UPDATED_AT = "updated_at";
    private static final String FIELD_CONCURRENCY_RESCHEDULE_COUNT = "concurrency_reschedule_count";
    private static final String FIELD_TRIGGERED_AT = "triggered_at";
    private static final String FIELD_CONSTRAINTS = "constraints";
    private static final String FIELD_LAST_EXECUTION_DURATION = "execution_duration";
    private static final String FIELD_IS_CANCELLED = "is_cancelled";
    private static final String FIELD_JOB_DEFINITION_TYPE = "job_definition_type";
    private final String nodeId;
    private final JobSchedulerClock clock;
    private final SchedulerCapabilitiesService schedulerCapabilitiesService;
    private final Duration lockExpirationDuration;
    private final MongoCollection<JobTriggerDto> collection;
    private final MongoUtils<JobTriggerDto> mongoUtils;

    @Inject
    public DBJobTriggerService(MongoCollections mongoCollections, NodeId nodeId, JobSchedulerClock clock, SchedulerCapabilitiesService schedulerCapabilitiesService, @Named(value="job_scheduler_lock_expiration_duration") Duration lockExpirationDuration) {
        this.nodeId = nodeId.getNodeId();
        this.clock = clock;
        this.schedulerCapabilitiesService = schedulerCapabilitiesService;
        this.lockExpirationDuration = lockExpirationDuration;
        this.collection = mongoCollections.collection(COLLECTION_NAME, JobTriggerDto.class);
        this.mongoUtils = mongoCollections.utils(this.collection);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{FIELD_JOB_DEFINITION_ID}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{FIELD_LOCK_OWNER}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{FIELD_STATUS}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{FIELD_START_TIME}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{FIELD_END_TIME}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{FIELD_NEXT_TIME}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{FIELD_CONSTRAINTS}));
        this.collection.createIndex(Indexes.ascending((String[])new String[]{FIELD_JOB_DEFINITION_TYPE}));
    }

    @Deprecated
    public DBJobTriggerService(MongoConnection mongoConnection, MongoCollections mongoCollections, MongoJackObjectMapperProvider mapper, NodeId nodeId, JobSchedulerClock clock, SchedulerCapabilitiesService schedulerCapabilitiesService, @Named(value="job_scheduler_lock_expiration_duration") Duration lockExpirationDuration) {
        this(mongoCollections, nodeId, clock, schedulerCapabilitiesService, lockExpirationDuration);
    }

    public List<JobTriggerDto> all() {
        return MongoUtils.stream(this.collection.find().sort(Sorts.descending((String[])new String[]{FIELD_ID}))).toList();
    }

    public Optional<JobTriggerDto> get(String id) {
        return this.mongoUtils.getById(id);
    }

    public Optional<JobTriggerDto> getOneForJob(String jobDefinitionId) {
        List<JobTriggerDto> triggers = this.getAllForJob(jobDefinitionId);
        if (triggers.size() > 1) {
            throw new IllegalStateException("More than one trigger for job definition <" + jobDefinitionId + ">");
        }
        return triggers.stream().findFirst();
    }

    public List<JobTriggerDto> getAllForJob(String jobDefinitionId) {
        if (Strings.isNullOrEmpty((String)jobDefinitionId)) {
            throw new IllegalArgumentException("jobDefinitionId cannot be null or empty");
        }
        return MongoUtils.stream(this.collection.find(Filters.eq((String)FIELD_JOB_DEFINITION_ID, (Object)jobDefinitionId))).toList();
    }

    public Map<String, List<JobTriggerDto>> getForJobs(Collection<String> jobDefinitionIds) {
        if (jobDefinitionIds == null) {
            throw new IllegalArgumentException("jobDefinitionIds cannot be null");
        }
        Set queryValues = jobDefinitionIds.stream().filter(Objects::nonNull).filter(id -> !Strings.isNullOrEmpty((String)id)).collect(Collectors.toSet());
        Bson filter = Filters.in((String)FIELD_JOB_DEFINITION_ID, queryValues);
        Map groupedTriggers = StreamEx.of(MongoUtils.stream(this.collection.find(filter))).groupingBy(JobTriggerDto::jobDefinitionId);
        for (Map.Entry entry : groupedTriggers.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            throw new IllegalStateException("More than one trigger for job definition <" + (String)entry.getKey() + ">");
        }
        return groupedTriggers;
    }

    public JobTriggerDto getOrCreate(JobTriggerDto trigger) {
        return this.mongoUtils.getOrCreate(Objects.requireNonNull(trigger, "trigger cannot be null"));
    }

    public JobTriggerDto create(JobTriggerDto trigger) {
        Objects.requireNonNull(trigger, "trigger cannot be null");
        if (trigger.id() != null) {
            throw new IllegalArgumentException("New trigger must not have an ID");
        }
        String id = MongoUtils.insertedIdAsString(this.collection.insertOne((Object)trigger));
        return trigger.toBuilder().id(id).build();
    }

    public boolean update(JobTriggerDto trigger) {
        Objects.requireNonNull(trigger, "trigger cannot be null");
        if (Strings.isNullOrEmpty((String)trigger.id())) {
            throw new IllegalArgumentException("Trigger must have an ID");
        }
        ArrayList<Bson> updates = new ArrayList<Bson>(List.of(Updates.set((String)FIELD_START_TIME, (Object)trigger.startTime()), Updates.set((String)FIELD_NEXT_TIME, (Object)trigger.nextTime()), Updates.set((String)FIELD_DATA, trigger.data()), Updates.set((String)FIELD_UPDATED_AT, (Object)this.clock.nowUTC()), Updates.set((String)FIELD_CONCURRENCY_RESCHEDULE_COUNT, (Object)trigger.concurrencyRescheduleCount()), Updates.set((String)FIELD_SCHEDULE, (Object)trigger.schedule())));
        if (trigger.endTime().isPresent()) {
            updates.add(Updates.set((String)FIELD_END_TIME, trigger.endTime()));
        }
        return this.collection.updateOne(MongoUtils.idEq(this.getId(trigger)), Updates.combine(updates)).getModifiedCount() > 0L;
    }

    public boolean delete(String triggerId) {
        if (Strings.isNullOrEmpty((String)triggerId)) {
            throw new IllegalArgumentException("triggerId cannot be null or empty");
        }
        return this.mongoUtils.deleteById(triggerId);
    }

    public int deleteCompletedOnceSchedulesOlderThan(long timeValue, TimeUnit unit) {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)FIELD_LOCK_OWNER, null), Filters.or((Bson[])new Bson[]{Filters.eq((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.COMPLETE)), Filters.eq((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.CANCELLED))}), Filters.eq((String)"schedule.type", (Object)"once"), Filters.lt((String)FIELD_UPDATED_AT, (Object)this.clock.nowUTC().minus(unit.toMillis(timeValue)))});
        return Ints.saturatedCast((long)this.collection.deleteMany(filter).getDeletedCount());
    }

    public int deleteByQuery(Bson query) {
        return Ints.saturatedCast((long)this.collection.deleteMany(query).getDeletedCount());
    }

    @Deprecated
    public int deleteByQuery(DBQuery.Query query) {
        this.mongoUtils.initializeLegacyMongoJackBsonObject((InitializationRequiredForTransformation)query);
        return this.deleteByQuery((Bson)query);
    }

    public long countByQuery(Bson query) {
        return this.collection.countDocuments(query);
    }

    @Deprecated
    public long countByQuery(DBQuery.Query query) {
        this.mongoUtils.initializeLegacyMongoJackBsonObject((InitializationRequiredForTransformation)query);
        return this.countByQuery((Bson)query);
    }

    public Optional<JobTriggerDto> nextRunnableTrigger() {
        DateTime now = this.clock.nowUTC();
        Bson constraintsQuery = Filters.not((Bson)Filters.elemMatch((String)FIELD_CONSTRAINTS, (Bson)new Document("$nin", this.schedulerCapabilitiesService.getNodeCapabilities())));
        Bson filter = Filters.or((Bson[])new Bson[]{Filters.and((Bson[])new Bson[]{Filters.eq((String)FIELD_LOCK_OWNER, null), Filters.eq((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNABLE)), Filters.lte((String)FIELD_START_TIME, (Object)now), constraintsQuery, Filters.or((Bson[])new Bson[]{Filters.not((Bson)Filters.exists((String)FIELD_END_TIME)), Filters.eq((String)FIELD_END_TIME, null), Filters.gt((String)FIELD_END_TIME, Optional.of(now))}), Filters.lte((String)FIELD_NEXT_TIME, (Object)now)}), Filters.and((Bson[])new Bson[]{Filters.ne((String)FIELD_LOCK_OWNER, null), Filters.ne((String)FIELD_LOCK_OWNER, (Object)this.nodeId), Filters.eq((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING)), constraintsQuery, Filters.lt((String)FIELD_LAST_LOCK_TIME, (Object)now.minus(this.lockExpirationDuration.toMilliseconds()))})});
        Bson sort = Sorts.ascending((String[])new String[]{FIELD_NEXT_TIME});
        Bson lockUpdate = Updates.combine((Bson[])new Bson[]{Updates.set((String)FIELD_LOCK_OWNER, (Object)this.nodeId), Updates.set((String)FIELD_LAST_LOCK_OWNER, (Object)this.nodeId), Updates.set((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING)), Updates.set((String)FIELD_TRIGGERED_AT, Optional.of(now)), Updates.set((String)FIELD_LAST_LOCK_TIME, (Object)now)});
        JobTriggerDto trigger = (JobTriggerDto)this.collection.findOneAndUpdate(filter, lockUpdate, new FindOneAndUpdateOptions().sort(sort).returnDocument(ReturnDocument.AFTER));
        return Optional.ofNullable(trigger);
    }

    public boolean releaseTrigger(JobTriggerDto trigger, JobTriggerUpdate triggerUpdate) {
        Objects.requireNonNull(trigger, "trigger cannot be null");
        Objects.requireNonNull(triggerUpdate, "triggerUpdate cannot be null");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)FIELD_LOCK_OWNER, (Object)this.nodeId), MongoUtils.idEq(this.getId(trigger)), Filters.eq((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING))});
        ArrayList<Bson> updates = new ArrayList<Bson>();
        updates.add(Updates.unset((String)FIELD_LOCK_OWNER));
        updates.add(Updates.set((String)FIELD_IS_CANCELLED, (Object)false));
        if (triggerUpdate.concurrencyReschedule()) {
            updates.add(Updates.inc((String)FIELD_CONCURRENCY_RESCHEDULE_COUNT, (Number)1));
        } else {
            updates.add(Updates.set((String)FIELD_CONCURRENCY_RESCHEDULE_COUNT, (Object)0));
        }
        if (triggerUpdate.nextTime().isPresent()) {
            if (triggerUpdate.status().isPresent()) {
                updates.add(Updates.set((String)FIELD_STATUS, (Object)((Object)triggerUpdate.status().get())));
            } else {
                updates.add(Updates.set((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNABLE)));
            }
            updates.add(Updates.set((String)FIELD_NEXT_TIME, (Object)triggerUpdate.nextTime().get()));
        } else {
            updates.add(Updates.set((String)FIELD_STATUS, (Object)((Object)triggerUpdate.status().orElse(JobTriggerStatus.COMPLETE))));
        }
        if (triggerUpdate.data().isPresent()) {
            updates.add(Updates.set((String)FIELD_DATA, triggerUpdate.data()));
        }
        trigger.triggeredAt().ifPresent(triggeredAt -> {
            org.joda.time.Duration duration = new org.joda.time.Duration((ReadableInstant)triggeredAt, (ReadableInstant)this.clock.nowUTC());
            updates.add(Updates.set((String)FIELD_LAST_EXECUTION_DURATION, Optional.of(duration.getMillis())));
        });
        return this.collection.updateOne(filter, Updates.combine(updates)).getModifiedCount() == 1L;
    }

    public int forceReleaseOwnedTriggers() {
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)FIELD_LOCK_OWNER, (Object)this.nodeId), Filters.eq((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING))});
        Bson update = Updates.combine((Bson[])new Bson[]{Updates.unset((String)FIELD_LOCK_OWNER), Updates.set((String)FIELD_IS_CANCELLED, (Object)false), Updates.set((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNABLE))});
        return Ints.saturatedCast((long)this.collection.updateMany(filter, update).getModifiedCount());
    }

    public boolean setTriggerError(JobTriggerDto trigger) {
        Objects.requireNonNull(trigger, "trigger cannot be null");
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)FIELD_LOCK_OWNER, (Object)this.nodeId), MongoUtils.idEq(this.getId(trigger))});
        Bson update = Updates.combine((Bson[])new Bson[]{Updates.unset((String)FIELD_LOCK_OWNER), Updates.set((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.ERROR))});
        return this.collection.updateOne(filter, update).getModifiedCount() > 0L;
    }

    private ObjectId getId(JobTriggerDto trigger) {
        return new ObjectId(Objects.requireNonNull(trigger.id(), "trigger ID cannot be null"));
    }

    public void updateLockedJobTriggers() {
        DateTime now = this.clock.nowUTC();
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)FIELD_LOCK_OWNER, (Object)this.nodeId), Filters.eq((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNING))});
        this.collection.updateMany(filter, Updates.set((String)FIELD_LAST_LOCK_TIME, (Object)now));
    }

    public int updateProgress(JobTriggerDto trigger, int progress) {
        Bson filter = MongoUtils.idEq(Objects.requireNonNull(trigger.id()));
        Bson update = Updates.set((String)FIELD_PROGRESS, (Object)progress);
        return Ints.saturatedCast((long)this.collection.updateOne(filter, update).getModifiedCount());
    }

    public Optional<JobTriggerDto> cancelTriggerByQuery(Bson query) {
        Bson update = Updates.set((String)FIELD_IS_CANCELLED, (Object)true);
        return Optional.ofNullable((JobTriggerDto)this.collection.findOneAndUpdate(query, update));
    }

    @Deprecated
    public Optional<JobTriggerDto> cancelTriggerByQuery(DBQuery.Query query) {
        this.mongoUtils.initializeLegacyMongoJackBsonObject((InitializationRequiredForTransformation)query);
        return this.cancelTriggerByQuery((Bson)query);
    }

    public List<JobTriggerDto> findByQuery(Bson query) {
        return MongoUtils.stream(this.collection.find(query).sort(Sorts.descending((String[])new String[]{FIELD_UPDATED_AT}))).toList();
    }

    @Deprecated
    public List<JobTriggerDto> findByQuery(DBQuery.Query query) {
        this.mongoUtils.initializeLegacyMongoJackBsonObject((InitializationRequiredForTransformation)query);
        return this.findByQuery((Bson)query);
    }

    public Map<String, Long> numberOfOverdueTriggers() {
        DateTime now = this.clock.nowUTC();
        AggregateIterable result = this.collection.aggregate(List.of(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.eq((String)FIELD_LOCK_OWNER, null), Filters.eq((String)FIELD_STATUS, (Object)((Object)JobTriggerStatus.RUNNABLE)), Filters.lte((String)FIELD_NEXT_TIME, (Object)now), Filters.or((Bson[])new Bson[]{Filters.not((Bson)Filters.exists((String)FIELD_END_TIME)), Filters.eq((String)FIELD_END_TIME, null), Filters.gte((String)FIELD_END_TIME, (Object)now)})})), Aggregates.group((Object)"$job_definition_type", (BsonField[])new BsonField[]{Accumulators.sum((String)"count", (Object)1)})), OverdueTrigger.class);
        return MongoUtils.stream(result).collect(Collectors.toMap(OverdueTrigger::type, OverdueTrigger::count));
    }

    private record OverdueTrigger(@JsonProperty(value="_id") String type, @JsonProperty(value="count") long count) {
    }
}

