/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import jakarta.inject.Inject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.graylog.security.certutil.CaKeystoreException;
import org.graylog.security.certutil.CaKeystoreWithPassword;
import org.graylog.security.certutil.CaPersistenceService;
import org.graylog.security.certutil.ca.exceptions.CACreationException;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog.security.certutil.cert.CertificateChain;
import org.graylog.security.certutil.csr.CsrSigner;
import org.graylog2.bootstrap.preflight.web.resources.model.CertificateAuthorityInformation;
import org.graylog2.cluster.certificates.CertificateSigningRequest;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaKeystore {
    private static final Logger LOG;
    private final CaPersistenceService caPersistenceService;
    private final CsrSigner csrSigner;
    public static final int DEFAULT_SELFSIGNED_VALIDITY_DAYS = 3650;

    @Inject
    public CaKeystore(CaPersistenceService caPersistenceService, CsrSigner csrSigner) {
        this.caPersistenceService = caPersistenceService;
        this.csrSigner = csrSigner;
    }

    public synchronized CertificateChain signCertificateRequest(CertificateSigningRequest request, RenewalPolicy renewalPolicy) throws CaKeystoreException {
        CaKeystoreWithPassword caKeystore = this.loadKeystore().orElseThrow(() -> new CaKeystoreException("Can't sign certificates, no CA configured!"));
        try {
            LOG.info("Signing certificate for  node {}, subject: {}", (Object)request.nodeId(), (Object)request.request().getSubject());
            PrivateKey caPrivateKey = (PrivateKey)caKeystore.keyStore().getKey("ca", caKeystore.password().toCharArray());
            X509Certificate caCertificate = (X509Certificate)caKeystore.keyStore().getCertificate("ca");
            X509Certificate cert = this.csrSigner.sign(caPrivateKey, caCertificate, request.request(), renewalPolicy);
            List<X509Certificate> caCertificates = List.of(caCertificate);
            return new CertificateChain(cert, caCertificates);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized boolean exists() {
        try {
            return this.loadKeystore().isPresent();
        }
        catch (CaKeystoreException e) {
            LOG.error("Failed to load CA keystore", (Throwable)e);
            return false;
        }
    }

    public synchronized Optional<CertificateAuthorityInformation> getInformation() {
        try {
            return this.caPersistenceService.get();
        }
        catch (KeyStoreStorageException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<CaKeystoreWithPassword> loadKeystore() throws CaKeystoreException {
        try {
            return this.caPersistenceService.loadKeyStore();
        }
        catch (KeyStoreStorageException e) {
            throw new CaKeystoreException(e);
        }
    }

    public CertificateAuthorityInformation createSelfSigned(String organization) throws CaKeystoreException {
        try {
            return this.caPersistenceService.create(organization, 3650);
        }
        catch (KeyStoreException | CACreationException | KeyStoreStorageException e) {
            throw new RuntimeException(e);
        }
    }

    public void createFromUpload(String password, List<FormDataBodyPart> files) throws CaKeystoreException {
        try {
            this.caPersistenceService.upload(password, files);
        }
        catch (CACreationException e) {
            throw new CaKeystoreException(e);
        }
    }

    public Optional<String> getEncodedCertificate() {
        return this.loadKeystore().map(CaKeystoreWithPassword::keyStore).map(ks -> {
            try {
                Certificate caPublicKey = ks.getCertificate("ca");
                return CaKeystore.encodeAsPem(caPublicKey);
            }
            catch (IOException | KeyStoreException e) {
                throw new RuntimeException("Failed to obtain CA public key", e);
            }
        });
    }

    private static String encodeAsPem(Object o) throws IOException {
        StringWriter writer = new StringWriter();
        try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)writer);){
            jcaPEMWriter.writeObject(o);
        }
        return writer.toString();
    }

    public void reset() {
        this.caPersistenceService.startOver();
    }

    public Optional<Date> getCertificateExpiration() {
        return this.loadKeystore().map(CaKeystoreWithPassword::keyStore).map(keyStore -> {
            try {
                Certificate certificate = keyStore.getCertificate("ca");
                return ((X509Certificate)certificate).getNotAfter();
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOG = LoggerFactory.getLogger(CaKeystore.class);
    }
}

