/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import jakarta.inject.Inject;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.graylog.security.certutil.CaKeystoreException;
import org.graylog.security.certutil.CaKeystoreWithPassword;
import org.graylog.security.certutil.CaPersistenceService;
import org.graylog.security.certutil.CaTruststore;
import org.graylog.security.certutil.CaTruststoreException;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;

public class CaTruststoreImpl
implements CaTruststore {
    private final CaPersistenceService caPersistenceService;

    @Inject
    public CaTruststoreImpl(CaPersistenceService caPersistenceService) {
        this.caPersistenceService = caPersistenceService;
    }

    @Override
    public Optional<KeyStore> getTrustStore() throws CaTruststoreException {
        try {
            return this.caPersistenceService.loadKeyStore().map(CaKeystoreWithPassword::keyStore).map(CaTruststoreImpl::filterOutPrivateKey);
        }
        catch (KeyStoreStorageException e) {
            throw new CaTruststoreException(e);
        }
    }

    @Nonnull
    private static KeyStore filterOutPrivateKey(KeyStore keyStore) {
        try {
            KeyStore truststore = KeyStore.getInstance("PKCS12", "BC");
            truststore.load(null, null);
            truststore.setCertificateEntry("ca", keyStore.getCertificate("ca"));
            return truststore;
        }
        catch (KeyStoreException | NoSuchProviderException e) {
            throw new CaKeystoreException(e);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

