/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record CertificateDto(String subject, String issuer, BigInteger serialNumber, Date validFrom, Date validTo, List<String> subjectAlternativeNames) {
    private static final Logger log = LoggerFactory.getLogger(CertificateDto.class);

    public CertificateDto(X509Certificate certificate) {
        this(certificate.getSubjectX500Principal().getName(), certificate.getIssuerX500Principal().getName(), certificate.getSerialNumber(), certificate.getNotBefore(), certificate.getNotAfter(), CertificateDto.getSubjectAlternativeNames(certificate));
    }

    private static List<String> getSubjectAlternativeNames(X509Certificate certificate) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
            if (altNames == null) {
                return names;
            }
            for (List<?> altName : altNames) {
                Object nameValue;
                if (altName.size() < 2 || !((nameValue = altName.get(1)) instanceof String)) continue;
                names.add((String)nameValue);
            }
        }
        catch (Exception e) {
            log.error("Error getting subject alternative names", (Throwable)e);
        }
        return names;
    }
}

