/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.time.Duration;
import java.util.List;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog.security.certutil.CertRequest;
import org.graylog.security.certutil.CertificateGenerator;
import org.graylog.security.certutil.KeyPair;
import org.graylog.security.certutil.PathTypeConverterProvider;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.SystemConsole;
import org.graylog.security.certutil.csr.CsrGenerator;
import org.graylog.security.certutil.csr.FilesystemKeystoreInformation;
import org.graylog.security.certutil.csr.storage.CsrFileStorage;
import org.graylog.security.certutil.csr.storage.CsrStorage;
import org.graylog2.bootstrap.CliCommand;

@Command(name="csr", description="Create CSR", groupNames={"certutil"})
public class CertutilCsr
implements CliCommand {
    @Option(name={"--keystore"}, description="Keystore with private key", typeConverterProvider=PathTypeConverterProvider.class)
    protected Path keystore = Path.of("keystore.jks", new String[0]);
    @Option(name={"--csrFile"}, description="Certificate signing request file")
    protected String csrFilename = "csr.csr";
    private final CommandLineConsole console;
    private final CsrStorage csrStorage;
    public static final CommandLineConsole.Prompt PROMPT_ENTER_PASSWORD_TO_PROTECT_YOUR_PRIVATE_KEY = CommandLineConsole.prompt("Enter password to protect your private key : ");

    public CertutilCsr() {
        this.console = new SystemConsole();
        this.csrStorage = new CsrFileStorage(this.csrFilename);
    }

    public CertutilCsr(Path keystore, String csrFilename, CommandLineConsole console) {
        this.keystore = keystore;
        this.csrFilename = csrFilename;
        this.console = console;
        this.csrStorage = new CsrFileStorage(csrFilename);
    }

    @Override
    public void run() {
        this.console.printLine("This tool will generate a CSR for the datanode");
        char[] privKeyPassword = this.console.readPassword(PROMPT_ENTER_PASSWORD_TO_PROTECT_YOUR_PRIVATE_KEY);
        try {
            KeyPair keyPair = CertificateGenerator.generate(CertRequest.selfSigned("datanode").isCA(false).validity(Duration.ofDays(36135L)));
            KeyStore keystore = keyPair.toKeystore("datanode", privKeyPassword);
            try (FileOutputStream fos = new FileOutputStream(this.keystore.toFile());){
                keystore.store(fos, privKeyPassword);
            }
            FilesystemKeystoreInformation keystoreInformation = new FilesystemKeystoreInformation(this.keystore, privKeyPassword);
            this.console.printLine("Generating CSR for the datanode");
            PKCS10CertificationRequest csr = CsrGenerator.generateCSR(keystoreInformation, "datanode", "localhost", List.of("data-node"));
            this.csrStorage.writeCsr(csr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

