/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.graylog2.plugin.certificates.RenewalPolicy;

public class CsrSigner {
    private static final Set<GeneralName> localhostAttributes = Set.of(new GeneralName(2, "localhost"), new GeneralName(7, "127.0.0.1"), new GeneralName(7, "0:0:0:0:0:0:0:1"));
    private final Clock clock;

    public CsrSigner() {
        this.clock = Clock.systemDefaultZone();
    }

    public CsrSigner(Clock clock) {
        this.clock = clock;
    }

    private boolean isValidName(int name) {
        return switch (name) {
            case 1, 2, 7 -> true;
            default -> false;
        };
    }

    private boolean isDNSName(int name) {
        return name == 2;
    }

    public X509Certificate sign(PrivateKey caPrivateKey, X509Certificate caCertificate, PKCS10CertificationRequest csr, RenewalPolicy renewalPolicy) throws Exception {
        Instant validFrom = Instant.now(this.clock);
        Instant validUntil = validFrom.plus(renewalPolicy.parsedCertificateLifetime());
        return this.sign(caPrivateKey, caCertificate, csr, validFrom, validUntil);
    }

    public X509Certificate sign(PrivateKey caPrivateKey, X509Certificate caCertificate, PKCS10CertificationRequest csr, int validityDays) throws Exception {
        Instant validFrom = Instant.now(this.clock);
        Instant validUntil = validFrom.plus(Duration.ofDays(validityDays));
        return this.sign(caPrivateKey, caCertificate, csr, validFrom, validUntil);
    }

    private X509Certificate sign(PrivateKey caPrivateKey, X509Certificate caCertificate, PKCS10CertificationRequest csr, Instant validFrom, Instant validUntil) throws Exception {
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        X500Name issuerName = X500Name.getInstance((Object)caCertificate.getSubjectX500Principal().getEncoded());
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuerName, serialNumber, Date.from(validFrom), Date.from(validUntil), csr.getSubject(), csr.getSubjectPublicKeyInfo());
        Set altNames = Optional.ofNullable(csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest)).stream().flatMap(Arrays::stream).map(attribute -> Extensions.getInstance((Object)attribute.getAttrValues().getObjectAt(0))).flatMap(extensions -> Optional.ofNullable(GeneralNames.fromExtensions((Extensions)extensions, (ASN1ObjectIdentifier)Extension.subjectAlternativeName)).flatMap(gns -> Optional.ofNullable(gns.getNames())).stream().flatMap(Arrays::stream)).filter(name -> this.isValidName(name.getTagNo())).flatMap(name -> this.isDNSName(name.getTagNo()) ? this.resolveDNSName((GeneralName)name) : Stream.of(name)).collect(Collectors.toSet());
        if (!altNames.isEmpty()) {
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames((GeneralName[])Sets.union(localhostAttributes, altNames).toArray((Object[])new GeneralName[0])));
        }
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(caPrivateKey);
        X509CertificateHolder certHolder = builder.build(signer);
        return new JcaX509CertificateConverter().getCertificate(certHolder);
    }

    private Stream<? extends GeneralName> resolveDNSName(GeneralName name) {
        String hostname = name.getName().toString();
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname);
            return Stream.of(name, new GeneralName(7, inetAddress.getHostAddress()));
        }
        catch (UnknownHostException e) {
            return Stream.of(name);
        }
    }
}

