/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.csr;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.graylog.security.certutil.csr.KeystoreInformation;

public record FilesystemKeystoreInformation(Path location, char[] password) implements KeystoreInformation
{
    public FilesystemKeystoreInformation(Path location, String password) {
        this(location, password.toCharArray());
    }

    @Override
    public KeyStore loadKeystore() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try (FileInputStream fis = new FileInputStream(this.location.toFile());){
            keyStore.load(fis, this.password);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }
}

