/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.keystore.storage;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Enumeration;

public class KeystoreUtils {
    private static final String SAMPLE_CHALLANGE = "Grayloggers! Grayloggers! Grayloggers! Grayloggers!";

    public static KeyStore newStoreCopyContent(KeyStore originalKeyStore, char[] currentPassword, char[] newPassword) throws GeneralSecurityException, IOException {
        if (newPassword == null) {
            throw new IllegalArgumentException("new password cannot be null");
        }
        KeyStore newKeyStore = KeyStore.getInstance("PKCS12");
        newKeyStore.load(null, newPassword);
        Enumeration<String> aliases = originalKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (originalKeyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                newKeyStore.setKeyEntry(alias, originalKeyStore.getKey(alias, currentPassword), newPassword, originalKeyStore.getCertificateChain(alias));
                continue;
            }
            if (originalKeyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
                newKeyStore.setCertificateEntry(alias, originalKeyStore.getCertificate(alias));
                continue;
            }
            if (!originalKeyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) continue;
            newKeyStore.setEntry(alias, originalKeyStore.getEntry(alias, new KeyStore.PasswordProtection(currentPassword)), new KeyStore.PasswordProtection(newPassword));
        }
        return newKeyStore;
    }

    public static boolean matchingKeys(PrivateKey privateKey, PublicKey publicKey) throws GeneralSecurityException {
        Signature sign = Signature.getInstance("SHA256withRSA");
        byte[] bytes = SAMPLE_CHALLANGE.getBytes(StandardCharsets.UTF_8);
        sign.initSign(privateKey);
        sign.update(bytes);
        byte[] signature = sign.sign();
        sign.initVerify(publicKey);
        sign.update(bytes);
        return sign.verify(signature);
    }
}

