/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.certutil.csr.ClientCert;
import org.graylog.security.certutil.csr.ClientCertGenerator;
import org.graylog.security.certutil.csr.exceptions.ClientCertGenerationException;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.bootstrap.preflight.web.resources.model.CreateClientCertRequest;
import org.graylog2.plugin.rest.ApiError;
import org.graylog2.shared.rest.resources.RestResource;

@Path(value="/ca/clientcert")
@Produces(value={"application/json"})
@RequiresAuthentication
@Api(value="CA CLient Certificates", description="Certificate Authority Client Certificates", tags={"cloud"})
public class CAClientResource
extends RestResource {
    private final ClientCertGenerator clientCertGenerator;

    @Inject
    public CAClientResource(ClientCertGenerator clientCertGenerator) {
        this.clientCertGenerator = clientCertGenerator;
    }

    @POST
    @AuditEvent(type="graylog_ca:clientcert:create")
    @ApiOperation(value="Creates a client certificate")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"ca_clientcert:create"})
    public Response createClientCert(@ApiParam(name="request", required=true) @NotNull @Valid CreateClientCertRequest request) {
        try {
            ClientCert cert = this.clientCertGenerator.generateClientCert(request.principal(), request.role(), request.password().toCharArray());
            return Response.ok().entity((Object)cert).build();
        }
        catch (ClientCertGenerationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiError.create(e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="{role}/{principal}")
    @AuditEvent(type="graylog_ca:clientcert:delete")
    @ApiOperation(value="removes the cert and the user from the role")
    @Produces(value={"application/json"})
    @RequiresPermissions(value={"ca_clientcert:delete"})
    public Response deleteClientCert(@ApiParam(name="role", required=true) @PathParam(value="role") String role, @ApiParam(name="principal", required=true) @PathParam(value="principal") String principal) {
        try {
            this.clientCertGenerator.removeCertFor(role, principal);
            return Response.ok().build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiError.create(e.getMessage())).build();
        }
    }
}

