/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.datanode.DataNodeCommandService;
import org.graylog2.datanode.DatanodeStartType;
import org.graylog2.plugin.rest.PluginRestResource;

@Api(value="Certificate Renewal")
@Path(value="/certrenewal")
@Produces(value={"application/json"})
@RequiresAuthentication
public class CertificateRenewalResource
implements PluginRestResource {
    private final DataNodeCommandService dataNodeCommandService;

    @Inject
    public CertificateRenewalResource(DataNodeCommandService dataNodeCommandService) {
        this.dataNodeCommandService = dataNodeCommandService;
    }

    @POST
    @Path(value="{nodeID}")
    @AuditEvent(type="server:certificate_renewal:manual")
    @RequiresPermissions(value={"clusterconfigentry:create", "clusterconfigentry:edit"})
    public void initiateCertRenewalForNode(@ApiParam(name="nodeID") @PathParam(value="nodeID") String nodeID) throws NodeNotFoundException {
        this.dataNodeCommandService.triggerCertificateSigningRequest(nodeID, DatanodeStartType.AUTOMATICALLY);
    }
}

