/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.certutil.CaTruststore;
import org.graylog.security.certutil.KeyStoreDto;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.security.CustomCAX509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/certificates")
@Produces(value={"application/json"})
@RequiresAuthentication
@Api(value="Certificates", description="Information about certificates used")
public class CertificatesResource {
    private final Logger log = LoggerFactory.getLogger(CertificatesResource.class);
    private final CaTruststore caTruststore;
    private final HttpConfiguration httpConfiguration;
    private final CustomCAX509TrustManager trustManager;

    @Inject
    public CertificatesResource(CaTruststore caTruststore, HttpConfiguration httpConfiguration, CustomCAX509TrustManager trustManager) {
        this.caTruststore = caTruststore;
        this.httpConfiguration = httpConfiguration;
        this.trustManager = trustManager;
    }

    @GET
    @ApiOperation(value="Returns the certificates used by this node")
    @RequiresPermissions(value={"graylog_ca:read"})
    public Map<Store, KeyStoreDto> getCertificates() {
        HashMap<Store, KeyStoreDto> certificates = new HashMap<Store, KeyStoreDto>();
        this.caTruststore.getTrustStore().ifPresent(truststore -> {
            try {
                certificates.put(Store.CONFIGURED_CA, KeyStoreDto.fromKeyStore(truststore));
            }
            catch (KeyStoreException e) {
                this.log.error("Error reading truststore", (Throwable)e);
            }
        });
        if (this.httpConfiguration.isHttpEnableTls()) {
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                try (ByteArrayInputStream inStream = new ByteArrayInputStream(Files.readAllBytes(this.httpConfiguration.getHttpTlsCertFile()));){
                    certificates.put(Store.HTTP, KeyStoreDto.fromSingleCertificate("tlscert", (X509Certificate)certFactory.generateCertificate(inStream)));
                }
            }
            catch (IOException | CertificateException e) {
                this.log.error("Error reading http tls certificate", (Throwable)e);
            }
        }
        certificates.put(Store.TRUSTSTORE, KeyStoreDto.fromCertificates("trustManager", this.trustManager.getAcceptedIssuers()));
        return certificates;
    }

    static enum Store {
        CONFIGURED_CA,
        TRUSTSTORE,
        HTTP;

    }
}

