/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alarmcallbacks;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog2.Configuration;
import org.graylog2.alerts.AlertSender;
import org.graylog2.alerts.EmailRecipients;
import org.graylog2.configuration.EmailConfiguration;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackConfigurationException;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackException;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.ListField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAlarmCallback
implements AlarmCallback {
    private static final Logger LOG = LoggerFactory.getLogger(EmailAlarmCallback.class);
    public static final String CK_USER_RECEIVERS = "user_receivers";
    public static final String CK_EMAIL_RECEIVERS = "email_receivers";
    private final AlertSender alertSender;
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private final EmailRecipients.Factory emailRecipientsFactory;
    private final UserService userService;
    private final EmailConfiguration emailConfiguration;
    private org.graylog2.plugin.configuration.Configuration configuration;
    private Configuration graylogConfig;

    @Inject
    public EmailAlarmCallback(AlertSender alertSender, NotificationService notificationService, NodeId nodeId, EmailRecipients.Factory emailRecipientsFactory, UserService userService, EmailConfiguration emailConfiguration, Configuration graylogConfig) {
        this.alertSender = alertSender;
        this.notificationService = notificationService;
        this.nodeId = nodeId;
        this.emailRecipientsFactory = emailRecipientsFactory;
        this.userService = userService;
        this.emailConfiguration = emailConfiguration;
        this.graylogConfig = graylogConfig;
    }

    @Override
    public void call(Stream stream, AlertCondition.CheckResult result) throws AlarmCallbackException {
        EmailRecipients emailRecipients = this.getEmailRecipients();
        if (emailRecipients.isEmpty()) {
            if (!this.emailConfiguration.isEnabled()) {
                throw new AlarmCallbackException("Email transport is not enabled in server configuration file!");
            }
            LOG.info("Alarm callback has no email recipients, not sending any emails.");
            return;
        }
        AlertCondition alertCondition = result.getTriggeredCondition();
        try {
            if (alertCondition.getBacklog() > 0 && result.getMatchingMessages() != null) {
                this.alertSender.sendEmails(stream, emailRecipients, result, this.getAlarmBacklog(result));
            } else {
                this.alertSender.sendEmails(stream, emailRecipients, result);
            }
        }
        catch (TransportConfigurationException e) {
            LOG.warn("Alarm callback has email recipients and is triggered, but email transport is not configured.");
            Notification notification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.EMAIL_TRANSPORT_CONFIGURATION_INVALID).addSeverity(Notification.Severity.NORMAL).addDetail("stream_id", stream.getId()).addDetail("exception", e.getMessage());
            this.notificationService.publishIfFirst(notification);
            throw new AlarmCallbackException(e.getMessage(), e);
        }
        catch (Exception e) {
            LOG.error("Alarm callback has email recipients and is triggered, but sending emails failed", (Throwable)e);
            Object exceptionDetail = e.toString();
            if (e.getCause() != null) {
                exceptionDetail = (String)exceptionDetail + " (" + e.getCause() + ")";
            }
            Notification notification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.EMAIL_TRANSPORT_FAILED).addSeverity(Notification.Severity.NORMAL).addDetail("stream_id", stream.getId()).addDetail("exception", exceptionDetail);
            this.notificationService.publishIfFirst(notification);
            throw new AlarmCallbackException(e.getMessage(), e);
        }
    }

    private EmailRecipients getEmailRecipients() {
        return this.emailRecipientsFactory.create(this.configuration.getList(CK_USER_RECEIVERS, Collections.emptyList()), this.configuration.getList(CK_EMAIL_RECEIVERS, Collections.emptyList()));
    }

    protected List<Message> getAlarmBacklog(AlertCondition.CheckResult result) {
        AlertCondition alertCondition = result.getTriggeredCondition();
        List<MessageSummary> matchingMessages = result.getMatchingMessages();
        int effectiveBacklogSize = Math.min(alertCondition.getBacklog(), matchingMessages.size());
        if (effectiveBacklogSize == 0) {
            return Collections.emptyList();
        }
        List<MessageSummary> backlogSummaries = matchingMessages.subList(0, effectiveBacklogSize);
        ArrayList backlog = Lists.newArrayListWithCapacity((int)effectiveBacklogSize);
        for (MessageSummary messageSummary : backlogSummaries) {
            backlog.add(messageSummary.getRawMessage());
        }
        return backlog;
    }

    @Override
    public void initialize(org.graylog2.plugin.configuration.Configuration config) throws AlarmCallbackConfigurationException {
        this.configuration = config;
        this.alertSender.initialize(this.configuration);
    }

    private ConfigurationRequest getConfigurationRequest(Map<String, String> userNames) {
        ConfigurationRequest configurationRequest = new ConfigurationRequest();
        if (!this.graylogConfig.isCloud()) {
            configurationRequest.addField(new TextField("sender", "Sender", "", "The sender of sent out mail alerts", ConfigurationField.Optional.OPTIONAL));
        }
        configurationRequest.addField(new TextField("subject", "E-Mail Subject", "Graylog alert for stream: ${stream.title}: ${check_result.resultDescription}", "The subject of sent out mail alerts", ConfigurationField.Optional.NOT_OPTIONAL));
        configurationRequest.addField(new TextField("body", "E-Mail Body", "##########\nAlert Description: ${check_result.resultDescription}\nDate: ${check_result.triggeredAt}\nStream ID: ${stream.id}\nStream title: ${stream.title}\nStream description: ${stream.description}\nAlert Condition Title: ${alertCondition.title}\n${if stream_url}Stream URL: ${stream_url}${end}\n\nTriggered condition: ${check_result.triggeredCondition}\n##########\n\n${if backlog}Last messages accounting for this alert:\n${foreach backlog message}${message}\n\n${end}${else}<No backlog>\n${end}\n", "The template to generate the body from", ConfigurationField.Optional.OPTIONAL, TextField.Attribute.TEXTAREA));
        configurationRequest.addField(new ListField(CK_USER_RECEIVERS, "User Receivers", Collections.emptyList(), userNames, "Graylog usernames that should receive this alert", ConfigurationField.Optional.OPTIONAL, new ListField.Attribute[0]));
        configurationRequest.addField(new ListField(CK_EMAIL_RECEIVERS, "E-Mail Receivers", Collections.emptyList(), Collections.emptyMap(), "E-Mail addresses that should receive this alert", ConfigurationField.Optional.OPTIONAL, ListField.Attribute.ALLOW_CREATE));
        return configurationRequest;
    }

    @Override
    public ConfigurationRequest getRequestedConfiguration() {
        return this.getConfigurationRequest(Collections.emptyMap());
    }

    public ConfigurationRequest getEnrichedRequestedConfiguration() {
        Map<String, String> regularUsers = this.userService.loadAll().stream().collect(Collectors.toMap(User::getName, User::getName));
        ImmutableMap userNames = ImmutableMap.builder().put((Object)this.graylogConfig.getRootUsername(), (Object)this.graylogConfig.getRootUsername()).putAll(regularUsers).build();
        return this.getConfigurationRequest((Map<String, String>)userNames);
    }

    @Override
    public String getName() {
        return "Email Alarm Callback [Deprecated]";
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.configuration.getSource();
    }

    @Override
    public void checkConfiguration() throws ConfigurationException {
        boolean missingSender;
        boolean bl = missingSender = Strings.isNullOrEmpty((String)this.configuration.getString("sender")) && Strings.isNullOrEmpty((String)this.emailConfiguration.getFromEmail());
        if (missingSender || Strings.isNullOrEmpty((String)this.configuration.getString("subject"))) {
            throw new ConfigurationException("Sender or subject are missing or invalid.");
        }
    }
}

