/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings;

import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.OptionalBinder;
import org.graylog2.Configuration;
import org.graylog2.outputs.BatchedMessageFilterOutput;
import org.graylog2.outputs.DefaultMessageOutput;
import org.graylog2.outputs.ElasticSearchOutput;
import org.graylog2.outputs.GelfOutput;
import org.graylog2.outputs.LoggingOutput;
import org.graylog2.outputs.filter.OutputFilterModule;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.shared.plugins.ChainingClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageOutputBindings
extends Graylog2Module {
    private static final Logger LOG = LoggerFactory.getLogger(MessageOutputBindings.class);
    private final Configuration configuration;
    private final ChainingClassLoader chainingClassLoader;

    public MessageOutputBindings(Configuration configuration, ChainingClassLoader chainingClassLoader) {
        this.configuration = configuration;
        this.chainingClassLoader = chainingClassLoader;
    }

    protected void configure() {
        Class<? extends MessageOutput> defaultMessageOutputClass = this.getDefaultMessageOutputClass(BatchedMessageFilterOutput.class);
        LOG.debug("Using default message output class: {}", (Object)defaultMessageOutputClass.getCanonicalName());
        OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(MessageOutput.class, DefaultMessageOutput.class)).setDefault().to(defaultMessageOutputClass).in(Scopes.SINGLETON);
        this.install((Module)new OutputFilterModule());
        this.filteredOutputsMapBinder();
        this.bind(ElasticSearchOutput.class).in(Scopes.SINGLETON);
        this.filteredOutputsMapBinder().addBinding((Object)"indexer").to(ElasticSearchOutput.class);
        MapBinder<String, MessageOutput.Factory<? extends MessageOutput>> outputMapBinder = this.outputsMapBinder();
        this.installOutput(outputMapBinder, GelfOutput.class, GelfOutput.Factory.class);
        this.installOutput(outputMapBinder, LoggingOutput.class, LoggingOutput.Factory.class);
    }

    private Class<? extends MessageOutput> getDefaultMessageOutputClass(Class<? extends MessageOutput> fallbackClass) {
        if (Strings.isNullOrEmpty((String)this.configuration.getDefaultMessageOutputClass())) {
            return fallbackClass;
        }
        try {
            Class<?> defaultMessageOutputClass = this.chainingClassLoader.loadClass(this.configuration.getDefaultMessageOutputClass());
            if (MessageOutput.class.isAssignableFrom(defaultMessageOutputClass)) {
                LOG.info("Using {} as default message output", (Object)defaultMessageOutputClass.getCanonicalName());
                return defaultMessageOutputClass;
            }
            LOG.warn("Class \"{}\" is not a subclass of \"{}\". Using \"{}\" as default message output", new Object[]{this.configuration.getDefaultMessageOutputClass(), MessageOutput.class.getCanonicalName(), fallbackClass.getCanonicalName()});
            return fallbackClass;
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Unable to find default message output class \"{}\", using \"{}\"", (Object)this.configuration.getDefaultMessageOutputClass(), (Object)fallbackClass.getCanonicalName());
            return fallbackClass;
        }
    }
}

