/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.Renderer;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

@Singleton
public class JsonSafeEngineProvider
implements Provider<Engine> {
    private final Engine engine = Engine.createEngine();

    @Inject
    public JsonSafeEngineProvider() {
        this.engine.registerRenderer(String.class, (Renderer)new JsonSafeRenderer());
    }

    public Engine get() {
        return this.engine;
    }

    private static class JsonSafeRenderer
    implements Renderer<String> {
        private JsonSafeRenderer() {
        }

        public String render(String s, Locale locale, Map<String, Object> map) {
            return StringEscapeUtils.escapeJava((String)s).replace("/", "\\/");
        }
    }
}

