/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.type.SimpleType;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.List;
import org.graylog.plugins.views.search.views.MongoIgnore;
import org.graylog2.indexer.retention.strategies.UnknownRetentionStrategyConfig;
import org.graylog2.jackson.MongoJodaDateTimeDeserializer;
import org.graylog2.jackson.MongoJodaDateTimeSerializer;
import org.graylog2.jackson.MongoZonedDateTimeDeserializer;
import org.graylog2.jackson.MongoZonedDateTimeSerializer;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.security.encryption.EncryptedValueMapperConfig;
import org.joda.time.DateTime;
import org.mongojack.internal.MongoJackModule;

@Singleton
public class MongoJackObjectMapperProvider
implements Provider<ObjectMapper> {
    private final ObjectMapper objectMapper;

    @Inject
    public MongoJackObjectMapperProvider(ObjectMapper objectMapper) {
        this.objectMapper = this.configure(objectMapper);
    }

    public ObjectMapper get() {
        return this.objectMapper;
    }

    private ObjectMapper configure(ObjectMapper objectMapper) {
        ObjectMapper configuredObjectMapper = objectMapper.copy().registerModule((Module)this.serializationModule()).addHandler((DeserializationProblemHandler)new ReplaceUnknownSubtypesWithFallbackHandler()).setPropertyNamingStrategy((PropertyNamingStrategy)new PreserveLeadingUnderscoreStrategy());
        EncryptedValueMapperConfig.enableDatabase(configuredObjectMapper);
        MongoJackModule.configure((ObjectMapper)configuredObjectMapper);
        return configuredObjectMapper;
    }

    private SimpleModule serializationModule() {
        return new SimpleModule("JSR-310-MongoJack").addSerializer(ZonedDateTime.class, (JsonSerializer)new MongoZonedDateTimeSerializer()).addDeserializer(ZonedDateTime.class, (JsonDeserializer)new MongoZonedDateTimeDeserializer()).addSerializer(DateTime.class, (JsonSerializer)new MongoJodaDateTimeSerializer()).addDeserializer(DateTime.class, (JsonDeserializer)new MongoJodaDateTimeDeserializer()).setSerializerModifier(this.serializerModifier());
    }

    private BeanSerializerModifier serializerModifier() {
        return new BeanSerializerModifier(){

            public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
                beanProperties.removeIf(prop -> prop.getAnnotation(MongoIgnore.class) != null);
                return beanProperties;
            }
        };
    }

    private static class ReplaceUnknownSubtypesWithFallbackHandler
    extends DeserializationProblemHandler {
        private ReplaceUnknownSubtypesWithFallbackHandler() {
        }

        public JavaType handleUnknownTypeId(DeserializationContext ctxt, JavaType baseType, String subTypeId, TypeIdResolver idResolver, String failureMsg) throws IOException {
            if (baseType.getRawClass().equals(RetentionStrategyConfig.class)) {
                return SimpleType.constructUnsafe(UnknownRetentionStrategyConfig.class);
            }
            return super.handleUnknownTypeId(ctxt, baseType, subTypeId, idResolver, failureMsg);
        }
    }

    public static class PreserveLeadingUnderscoreStrategy
    extends PropertyNamingStrategies.SnakeCaseStrategy {
        public String translate(String input) {
            Object translated = super.translate(input);
            if (input.startsWith("_") && !((String)translated).startsWith("_")) {
                translated = "_" + (String)translated;
            }
            return translated;
        }
    }
}

