/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joschi.jadconfig.util.Duration;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import okhttp3.OkHttpClient;
import org.graylog2.bootstrap.preflight.web.resources.ConnectionCheckResult;
import org.graylog2.bootstrap.preflight.web.resources.VersionProbeMessageCollector;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.security.IndexerJwtAuthTokenProvider;
import org.graylog2.storage.versionprobe.VersionProbe;
import org.graylog2.storage.versionprobe.VersionProbeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatanodeConnectivityCheck {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeConnectivityCheck.class);
    private final VersionProbe versionProbe;

    @Inject
    public DatanodeConnectivityCheck(ObjectMapper objectMapper, OkHttpClient okHttpClient, @Named(value="indexer_use_jwt_authentication") boolean opensearchUseJwtAuthentication, IndexerJwtAuthTokenProvider indexerJwtAuthTokenProvider) {
        this.versionProbe = new VersionProbe(objectMapper, okHttpClient, 1, Duration.seconds((long)1L), true, opensearchUseJwtAuthentication, indexerJwtAuthTokenProvider);
    }

    public ConnectionCheckResult probe(DataNodeDto node) {
        List<URI> hosts = Collections.singletonList(URI.create(node.getTransportAddress()));
        VersionProbeMessageCollector messageCollector = new VersionProbeMessageCollector(new VersionProbeLogger(LOG));
        return this.versionProbe.probe(hosts, messageCollector).map(ConnectionCheckResult::success).orElse(ConnectionCheckResult.failure(messageCollector.joinedMessages()));
    }
}

