/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.graylog.security.certutil.CaKeystore;
import org.graylog.security.certutil.CaKeystoreException;
import org.graylog.security.certutil.ca.exceptions.CACreationException;
import org.graylog.security.certutil.ca.exceptions.KeyStoreStorageException;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.bootstrap.preflight.web.resources.ConnectionCheckResult;
import org.graylog2.bootstrap.preflight.web.resources.DatanodeConnectivityCheck;
import org.graylog2.bootstrap.preflight.web.resources.ProvisioningState;
import org.graylog2.bootstrap.preflight.web.resources.model.CertParameters;
import org.graylog2.bootstrap.preflight.web.resources.model.CertificateAuthorityInformation;
import org.graylog2.bootstrap.preflight.web.resources.model.CreateCARequest;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.DataNodeStatus;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.cluster.preflight.DataNodeProvisioningConfig;
import org.graylog2.datanode.DataNodeCommandService;
import org.graylog2.datanode.DatanodeStartType;
import org.graylog2.plugin.certificates.RenewalPolicy;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.rest.ApiError;

@Path(value="/api/")
@Produces(value={"application/json"})
public class PreflightResource {
    private final NodeService<DataNodeDto> nodeService;
    private final CaKeystore caKeystore;
    private final ClusterConfigService clusterConfigService;
    private final DataNodeCommandService dataNodeCommandService;
    private final DatanodeConnectivityCheck datanodeConnectivityCheck;

    @Inject
    public PreflightResource(NodeService<DataNodeDto> nodeService, CaKeystore caKeystore, ClusterConfigService clusterConfigService, DataNodeCommandService dataNodeCommandService, DatanodeConnectivityCheck datanodeConnectivityCheck) {
        this.nodeService = nodeService;
        this.caKeystore = caKeystore;
        this.clusterConfigService = clusterConfigService;
        this.dataNodeCommandService = dataNodeCommandService;
        this.datanodeConnectivityCheck = datanodeConnectivityCheck;
    }

    @GET
    @Path(value="/data_nodes")
    @RequiresPermissions(value={"preflight:only"})
    public List<DataNode> listDataNodes() {
        Map<String, DataNodeDto> activeDataNodes = this.nodeService.allActive();
        return activeDataNodes.values().stream().map(n -> {
            ProvisioningState provisioningState = this.getProvisioningState((DataNodeDto)n);
            return new DataNode(n.getNodeId(), n.getTransportAddress(), provisioningState.state(), provisioningState.error(), n.getHostname(), n.getShortNodeId(), n.getDataNodeStatus());
        }).collect(Collectors.toList());
    }

    public ProvisioningState getProvisioningState(DataNodeDto n) {
        return switch (n.getDataNodeStatus()) {
            case DataNodeStatus.AVAILABLE -> this.verifyActualConnection(n);
            case DataNodeStatus.STARTING -> new ProvisioningState(DataNodeProvisioningConfig.State.STARTING);
            case DataNodeStatus.PREPARED -> new ProvisioningState(DataNodeProvisioningConfig.State.PROVISIONED);
            case DataNodeStatus.UNAVAILABLE -> new ProvisioningState(DataNodeProvisioningConfig.State.ERROR);
            default -> new ProvisioningState(DataNodeProvisioningConfig.State.UNCONFIGURED);
        };
    }

    private ProvisioningState verifyActualConnection(DataNodeDto n) {
        ConnectionCheckResult result = this.datanodeConnectivityCheck.probe(n);
        DataNodeProvisioningConfig.State state = result.succeeded() ? DataNodeProvisioningConfig.State.CONNECTED : DataNodeProvisioningConfig.State.STARTING;
        return new ProvisioningState(state, result.errorMessage());
    }

    @GET
    @Path(value="/ca")
    @RequiresPermissions(value={"preflight:only"})
    public CertificateAuthorityInformation get() throws KeyStoreStorageException {
        return this.caKeystore.getInformation().orElse(null);
    }

    @GET
    @Path(value="/ca/certificate")
    @Produces(value={"text/plain"})
    @RequiresPermissions(value={"preflight:only"})
    public String getCaCertificate() {
        return this.caKeystore.getEncodedCertificate().orElseThrow(() -> new IllegalStateException("CA keystore not available"));
    }

    @POST
    @Path(value="/ca/create")
    @RequiresPermissions(value={"preflight:only"})
    @NoAuditEvent(value="No Auditing during preflight")
    public Response createCA(@NotNull @Valid CreateCARequest request) throws CACreationException, KeyStoreStorageException, KeyStoreException, NoSuchAlgorithmException {
        CertificateAuthorityInformation ca = this.caKeystore.createSelfSigned(request.organization());
        return Response.created((URI)URI.create("/api/ca")).entity((Object)ca).build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/ca/upload")
    @RequiresPermissions(value={"preflight:only"})
    @NoAuditEvent(value="No Auditing during preflight")
    public Response uploadCA(@FormDataParam(value="password") String password, @FormDataParam(value="files") List<FormDataBodyPart> bodyParts) {
        try {
            this.caKeystore.createFromUpload(password, bodyParts);
            return Response.ok().build();
        }
        catch (CaKeystoreException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ApiError.create(e.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="/startOver")
    @RequiresPermissions(value={"preflight:only"})
    @NoAuditEvent(value="No Auditing during preflight")
    public void startOver() {
        this.caKeystore.reset();
        this.clusterConfigService.remove(RenewalPolicy.class);
        this.nodeService.allActive().values().stream().filter(n -> n.getDataNodeStatus() == DataNodeStatus.AVAILABLE).forEach(this::stopNode);
    }

    private void stopNode(DataNodeDto node) {
        try {
            this.dataNodeCommandService.stopNode(node.getNodeId());
        }
        catch (NodeNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @DELETE
    @Path(value="/startOver/{nodeID}")
    @RequiresPermissions(value={"preflight:only"})
    @NoAuditEvent(value="No Auditing during preflight")
    public void startOver(@PathParam(value="nodeID") String nodeID) {
    }

    @POST
    @Path(value="/generate")
    @RequiresPermissions(value={"preflight:only"})
    @NoAuditEvent(value="No Auditing during preflight")
    public void generate() {
        Map<String, DataNodeDto> activeDataNodes = this.nodeService.allActive();
        activeDataNodes.values().forEach(node -> {
            try {
                this.dataNodeCommandService.triggerCertificateSigningRequest(node.getNodeId(), DatanodeStartType.AUTOMATICALLY);
            }
            catch (NodeNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @POST
    @Path(value="/{nodeID}")
    @Consumes(value={"application/json"})
    @RequiresPermissions(value={"preflight:only"})
    @NoAuditEvent(value="No Auditing during preflight")
    public void addParameters(@PathParam(value="nodeID") String nodeID, @NotNull CertParameters params) {
        throw new UnsupportedOperationException("Adding cert parameters not supported yet");
    }

    public record DataNode(String nodeId, String transportAddress, DataNodeProvisioningConfig.State status, String errorMsg, String hostname, String shortNodeId, DataNodeStatus dataNodeStatus) {
    }
}

