/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.StringNotBlankValidator;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import org.graylog2.configuration.Documentation;

public class MongoDbConfiguration {
    @Documentation(value="Increase this value according to the maximum connections your MongoDB server can handle from a single client if you encounter MongoDB connection problems.")
    @Parameter(value="mongodb_max_connections", validator=PositiveIntegerValidator.class)
    private int maxConnections = 1000;
    @Documentation(value="MongoDB connection string. See https://docs.mongodb.com/manual/reference/connection-string/ for details")
    @Parameter(value="mongodb_uri", required=true, validator=StringNotBlankValidator.class)
    private String uri = "mongodb://localhost/graylog";
    @Documentation(value="Maximum number of attempts to connect to MongoDB on boot for the version probe.Default 0 means retry indefinitely until a connection can be established")
    @Parameter(value="mongodb_version_probe_attempts", validators={PositiveIntegerValidator.class})
    int mongodbVersionProbeAttempts = 0;

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public MongoClientURI getMongoClientURI() {
        MongoClientOptions.Builder mongoClientOptionsBuilder = MongoClientOptions.builder().connectionsPerHost(this.getMaxConnections());
        return new MongoClientURI(this.uri, mongoClientOptionsBuilder);
    }

    @ValidatorMethod
    public void validate() throws ValidationException {
        if (this.getMongoClientURI() == null) {
            throw new ValidationException("mongodb_uri is not a valid MongoDB connection string");
        }
    }
}

