/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import org.graylog2.configuration.converters.SortedPathSetConverter;

public class PathConfiguration {
    public static final String ALLOWED_AUXILIARY_PATHS = "allowed_auxiliary_paths";
    protected static final Path DEFAULT_BIN_DIR = Paths.get("bin", new String[0]);
    protected static final Path DEFAULT_PLUGIN_DIR = Paths.get("plugin", new String[0]);
    @Parameter(value="bin_dir", required=true)
    private Path binDir = DEFAULT_BIN_DIR;
    @Parameter(value="data_dir", required=true)
    private Path dataDir;
    @Parameter(value="plugin_dir", required=true)
    private Path pluginDir = DEFAULT_PLUGIN_DIR;
    @Parameter(value="allowed_auxiliary_paths", converter=SortedPathSetConverter.class)
    private SortedSet<Path> allowedAuxiliaryPaths = Collections.emptySortedSet();

    public Path getBinDir() {
        return this.binDir;
    }

    public Path getDataDir() {
        return this.dataDir;
    }

    public Path getNativeLibDir() {
        return this.dataDir.resolve("libnative");
    }

    public Path getPluginDir() {
        return this.pluginDir;
    }

    public Set<Path> getAllowedAuxiliaryPaths() {
        return this.allowedAuxiliaryPaths;
    }
}

