/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.converters.StringSetConverter;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog2.configuration.Documentation;
import org.graylog2.shared.security.tls.DefaultTLSProtocolProvider;

public class TLSProtocolsConfiguration {
    @Documentation(value="allowed TLS protocols for system wide TLS enabled servers. (e.g. message inputs, http interface).Setting this to an empty value, leaves it up to system libraries and the used JDK to chose a default.")
    @Parameter(value="enabled_tls_protocols", converter=StringSetConverter.class)
    private Set<String> enabledTlsProtocols = null;

    public TLSProtocolsConfiguration() {
    }

    public TLSProtocolsConfiguration(Set<String> enabledTlsProtocols) {
        this.enabledTlsProtocols = enabledTlsProtocols;
    }

    @Nullable
    public Set<String> getConfiguredTlsProtocols() {
        return this.enabledTlsProtocols;
    }

    public Set<String> getEnabledTlsProtocols() {
        if (this.enabledTlsProtocols != null) {
            if (this.enabledTlsProtocols.isEmpty()) {
                return DefaultTLSProtocolProvider.getAllSupportedTlsProtocols();
            }
            return this.enabledTlsProtocols;
        }
        return DefaultTLSProtocolProvider.getSecureTLSProtocols();
    }
}

