/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.PluginVersionConstraint;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.OutputEntity;
import org.graylog2.contentpacks.model.entities.references.ReferenceMapUtils;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.streams.Output;
import org.graylog2.rest.models.streams.outputs.requests.CreateOutputRequest;
import org.graylog2.streams.OutputService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputFacade
implements EntityFacade<Output> {
    private static final Logger LOG = LoggerFactory.getLogger(OutputFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.OUTPUT_V1;
    private final ObjectMapper objectMapper;
    private final OutputService outputService;
    private final Set<PluginMetaData> pluginMetaData;
    private final Map<String, MessageOutput.Factory<? extends MessageOutput>> outputFactories;
    private final Map<String, MessageOutput.Factory2<? extends MessageOutput>> outputFactories2;

    @Inject
    public OutputFacade(ObjectMapper objectMapper, OutputService outputService, Set<PluginMetaData> pluginMetaData, Map<String, MessageOutput.Factory<? extends MessageOutput>> outputFactories, Map<String, MessageOutput.Factory2<? extends MessageOutput>> outputFactories2) {
        this.objectMapper = objectMapper;
        this.outputService = outputService;
        this.pluginMetaData = pluginMetaData;
        this.outputFactories = outputFactories;
        this.outputFactories2 = outputFactories2;
    }

    @VisibleForTesting
    Entity exportNativeEntity(Output output, EntityDescriptorIds entityDescriptorIds) {
        OutputEntity outputEntity = OutputEntity.create(ValueReference.of(output.getTitle()), ValueReference.of(output.getType()), ReferenceMapUtils.toReferenceMap(output.getConfiguration()));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)outputEntity, JsonNode.class);
        Set<Constraint> constraints = this.versionConstraints(output);
        return ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(output.getId(), ModelTypes.OUTPUT_V1)))).type(ModelTypes.OUTPUT_V1)).constraints((ImmutableSet<Constraint>)ImmutableSet.copyOf(constraints)).data(data).build();
    }

    private Set<Constraint> versionConstraints(Output output) {
        MessageOutput.Factory<? extends MessageOutput> outputFactory = this.outputFactories.get(output.getType());
        MessageOutput.Factory2<? extends MessageOutput> outputFactory2 = this.outputFactories2.get(output.getType());
        if (outputFactory == null && outputFactory2 == null) {
            throw new ContentPackException("Unknown output type: " + output.getType());
        }
        String packageName = outputFactory2 != null ? outputFactory2.getDescriptor().getClass().getPackage().getName() : outputFactory.getDescriptor().getClass().getPackage().getName();
        return this.pluginMetaData.stream().filter(metaData -> packageName.startsWith(metaData.getClass().getPackage().getName())).map(PluginVersionConstraint::of).collect(Collectors.toSet());
    }

    @Override
    public NativeEntity<Output> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, username);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<Output> decode(EntityV1 entity, Map<String, ValueReference> parameters, String username) {
        OutputEntity outputEntity = (OutputEntity)this.objectMapper.convertValue((Object)entity.data(), OutputEntity.class);
        CreateOutputRequest createOutputRequest = CreateOutputRequest.create(outputEntity.title().asString(parameters), outputEntity.type().asString(parameters), ReferenceMapUtils.toValueMap(outputEntity.configuration(), parameters), null);
        try {
            Output output = this.outputService.create(createOutputRequest, username);
            return NativeEntity.create(entity.id(), output.getId(), TYPE_V1, output.getTitle(), output);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Optional<NativeEntity<Output>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        try {
            Output output = this.outputService.load(nativeEntityDescriptor.id().id());
            return Optional.of(NativeEntity.create(nativeEntityDescriptor, output));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public void delete(Output nativeEntity) {
        try {
            this.outputService.destroy(nativeEntity);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    public EntityExcerpt createExcerpt(Output output) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(output.getId()))).type(ModelTypes.OUTPUT_V1)).title(output.getTitle()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.outputService.loadAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        try {
            Output output = this.outputService.load(modelId.id());
            return Optional.of(this.exportNativeEntity(output, entityDescriptorIds));
        }
        catch (NotFoundException e) {
            LOG.debug("Couldn't find output {}", (Object)entityDescriptor, (Object)e);
            return Optional.empty();
        }
    }
}

