/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import jakarta.inject.Inject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.db.SearchDbService;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.plugins.views.search.views.ViewStateDTO;
import org.graylog.plugins.views.search.views.ViewSummaryDTO;
import org.graylog.plugins.views.search.views.ViewSummaryService;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.facades.EntityWithExcerptFacade;
import org.graylog2.contentpacks.facades.StreamReferenceFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.SearchEntity;
import org.graylog2.contentpacks.model.entities.ViewEntity;
import org.graylog2.contentpacks.model.entities.ViewStateEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ViewFacade
implements EntityWithExcerptFacade<ViewDTO, ViewSummaryDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(ViewFacade.class);
    private final ObjectMapper objectMapper;
    private final ViewService viewService;
    private final SearchDbService searchDbService;
    private final ViewSummaryService viewSummaryService;
    protected final UserService userService;

    @Inject
    public ViewFacade(ObjectMapper objectMapper, SearchDbService searchDbService, ViewService viewService, ViewSummaryService viewSummaryService, UserService userService) {
        this.objectMapper = objectMapper;
        this.searchDbService = searchDbService;
        this.viewService = viewService;
        this.viewSummaryService = viewSummaryService;
        this.userService = userService;
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        Optional<ViewDTO> optionalView = this.viewService.get(modelId.id());
        if (optionalView.isPresent()) {
            return Optional.of(this.exportNativeEntity(optionalView.get(), entityDescriptorIds));
        }
        LOG.debug("Couldn't find view {}", (Object)entityDescriptor);
        return Optional.empty();
    }

    private Entity exportNativeEntity(ViewDTO view, EntityDescriptorIds entityDescriptorIds) {
        ViewEntity.Builder viewEntityBuilder = view.toContentPackEntity(entityDescriptorIds);
        Optional<Search> optionalSearch = this.searchDbService.get(view.searchId());
        Search search = optionalSearch.orElseThrow(() -> new IllegalArgumentException("Search is missing in view " + view.searchId()));
        SearchEntity searchEntity = search.toContentPackEntity(entityDescriptorIds);
        ViewEntity viewEntity = viewEntityBuilder.search(searchEntity).build();
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)viewEntity, JsonNode.class);
        return ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(EntityDescriptor.create(view.id(), this.getModelType()))))).type(this.getModelType())).data(data).build();
    }

    public abstract ModelType getModelType();

    protected void ensureV1(Entity entity) {
        if (!(entity instanceof EntityV1)) {
            throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
        }
    }

    @Override
    public NativeEntity<ViewDTO> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        this.ensureV1(entity);
        User user = Optional.ofNullable(this.userService.load(username)).orElseThrow(() -> new IllegalStateException("Cannot load user <" + username + "> from db"));
        return this.decode((EntityV1)entity, parameters, nativeEntities, user);
    }

    protected NativeEntity<ViewDTO> decode(EntityV1 entityV1, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, User user) {
        ViewEntity viewEntity = (ViewEntity)this.objectMapper.convertValue((Object)entityV1.data(), ViewEntity.class);
        LinkedHashMap<String, ViewStateDTO> viewStateMap = new LinkedHashMap<String, ViewStateDTO>(viewEntity.state().size());
        for (Map.Entry<String, ViewStateEntity> entry : viewEntity.state().entrySet()) {
            ViewStateEntity entity = entry.getValue();
            viewStateMap.put(entry.getKey(), (ViewStateDTO)entity.toNativeEntity((Map)parameters, (Map)nativeEntities));
        }
        Object viewBuilder = viewEntity.toNativeEntity((Map)parameters, (Map)nativeEntities);
        ((ViewDTO.Builder)viewBuilder).state(viewStateMap);
        Object search = viewEntity.search().toNativeEntity((Map)parameters, (Map)nativeEntities);
        Search persistedSearch = this.searchDbService.save((Search)search);
        ViewDTO persistedView = this.viewService.saveWithOwner(((ViewDTO.Builder)viewBuilder).searchId(persistedSearch.id()).build(), user);
        return NativeEntity.create(entityV1.id(), persistedView.id(), this.getModelType(), persistedView.title(), persistedView);
    }

    @Override
    public Optional<NativeEntity<ViewDTO>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        Optional<ViewDTO> optionalViewDTO = this.viewService.get(nativeEntityDescriptor.id().id());
        return optionalViewDTO.map(viewDTO -> NativeEntity.create(nativeEntityDescriptor, viewDTO));
    }

    @Override
    public void delete(ViewDTO nativeEntity) {
        this.viewService.delete(nativeEntity.id());
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.getNativeViews().map(this::createExcerpt).collect(Collectors.toSet());
    }

    protected Stream<ViewSummaryDTO> getNativeViews() {
        return this.viewSummaryService.streamAll().filter(v -> v.type().equals((Object)this.getDTOType()));
    }

    @Override
    public EntityExcerpt createExcerpt(ViewSummaryDTO nativeEntity) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(nativeEntity.id()))).type(this.getModelType())).title(nativeEntity.title()).build();
    }

    public abstract ViewDTO.Type getDTOType();

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        ModelId modelId = entityDescriptor.id();
        ViewDTO view = this.viewService.get(modelId.id()).orElseThrow(() -> new NoSuchElementException("Could not find view with id " + modelId.id()));
        view.resolveNativeEntity(entityDescriptor, (MutableGraph<EntityDescriptor>)mutableGraph);
        ViewSummaryDTO viewSummaryDTO = (ViewSummaryDTO)this.viewSummaryService.get(modelId.id()).orElseThrow(() -> new NoSuchElementException("Could not find view with id " + modelId.id()));
        Search search = this.searchDbService.get(viewSummaryDTO.searchId()).orElseThrow(() -> new NoSuchElementException("Could not find search with id " + viewSummaryDTO.searchId()));
        search.usedStreamIds().stream().map(s -> EntityDescriptor.create(s, ModelTypes.STREAM_REF_V1)).forEach(streamDescriptor -> mutableGraph.putEdge((Object)entityDescriptor, streamDescriptor));
        search.resolveNativeEntity(entityDescriptor, (MutableGraph<EntityDescriptor>)mutableGraph);
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        this.ensureV1(entity);
        return this.resolveEntityV1((EntityV1)entity, parameters, entities);
    }

    private Graph<Entity> resolveEntityV1(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        ViewEntity viewEntity = (ViewEntity)this.objectMapper.convertValue((Object)entity.data(), ViewEntity.class);
        return this.resolveViewEntity(entity, viewEntity, parameters, entities);
    }

    protected Graph<Entity> resolveViewEntity(EntityV1 entity, ViewEntity viewEntity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entity);
        viewEntity.search().usedStreamIds().stream().map(id -> StreamReferenceFacade.resolveStreamEntity(id, entities)).filter(Objects::nonNull).forEach(stream -> mutableGraph.putEdge((Object)entity, stream));
        viewEntity.state().values().stream().flatMap(s -> s.widgets().stream()).flatMap(w -> w.streams().stream()).map(id -> StreamReferenceFacade.resolveStreamEntity(id, entities)).filter(Objects::nonNull).forEach(stream -> mutableGraph.putEdge((Object)entity, stream));
        viewEntity.resolveForInstallation(entity, parameters, entities, (MutableGraph<Entity>)mutableGraph);
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }
}

