/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.graylog2.contentpacks.model.AutoValue_ModelType;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ModelType {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_VERSION = "version";

    @JsonProperty(value="name")
    public abstract String name();

    @JsonProperty(value="version")
    public abstract String version();

    public static ModelType of(String name, String version) {
        ModelType.validate(name, version);
        return Builder.create().name(name).version(version).build();
    }

    private static void validate(String name, String version) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Type name must not be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)version), (Object)"Type version must not be blank");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_ModelType.Builder();
        }

        @JsonProperty(value="name")
        public abstract Builder name(String var1);

        @JsonProperty(value="version")
        public abstract Builder version(String var1);

        public abstract ModelType autoBuild();

        public ModelType build() {
            ModelType modelType = this.autoBuild();
            ModelType.validate(modelType.name(), modelType.version());
            return modelType;
        }
    }
}

