/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.graylog.plugins.views.search.views.Titles;
import org.graylog.plugins.views.search.views.WidgetPositionDTO;
import org.graylog2.contentpacks.model.entities.AutoValue_DashboardEntity;
import org.graylog2.contentpacks.model.entities.DashboardWidgetEntity;
import org.graylog2.contentpacks.model.entities.WidgetEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

@JsonAutoDetect
@AutoValue
public abstract class DashboardEntity {
    @JsonProperty(value="title")
    @NotBlank
    public abstract ValueReference title();

    @JsonProperty(value="description")
    public abstract ValueReference description();

    @JsonProperty(value="widgets")
    @NotNull
    public abstract List<DashboardWidgetEntity> widgets();

    public static Map<String, WidgetPositionDTO> positionMap(Map<String, ValueReference> parameters, Map<DashboardWidgetEntity, List<WidgetEntity>> widgetMap) {
        HashMap widgetPositionMap = new HashMap();
        for (Map.Entry<DashboardWidgetEntity, List<WidgetEntity>> widgetEntityListEntry : widgetMap.entrySet()) {
            DashboardWidgetEntity dashboardWidgetEntity = widgetEntityListEntry.getKey();
            Optional<DashboardWidgetEntity.Position> position = dashboardWidgetEntity.position();
            widgetEntityListEntry.getValue().forEach(widgetEntity -> position.ifPresent(value -> widgetPositionMap.put(widgetEntity.id(), value.convert(parameters))));
        }
        return ImmutableMap.copyOf(widgetPositionMap);
    }

    public static Titles widgetTitles(Map<DashboardWidgetEntity, List<WidgetEntity>> widgetMap, Map<String, ValueReference> parameters) {
        HashMap<String, String> widgetTitleMap = new HashMap<String, String>();
        for (Map.Entry<DashboardWidgetEntity, List<WidgetEntity>> widgetEntityListEntry : widgetMap.entrySet()) {
            widgetEntityListEntry.getValue().forEach(widgetEntity -> widgetTitleMap.put(widgetEntity.id(), ((DashboardWidgetEntity)widgetEntityListEntry.getKey()).description().asString(parameters)));
        }
        return Titles.withWidgetTitle(widgetTitleMap);
    }

    @JsonCreator
    public static DashboardEntity create(@JsonProperty(value="title") @NotBlank ValueReference title, @JsonProperty(value="description") ValueReference description, @JsonProperty(value="widgets") @NotNull List<DashboardWidgetEntity> widgets) {
        return new AutoValue_DashboardEntity(title, description, widgets);
    }
}

