/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.github.zafarkhaja.semver.Version;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.bootstrap.preflight.PreflightCheckException;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBVersionCheck {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBVersionCheck.class);
    private static final Version MINIMUM_MONGODB_VERSION = Version.of((long)5L, (long)0L);

    public static Version getVersion(MongoClient mongoClient) {
        MongoDatabase adminDb = mongoClient.getDatabase("admin");
        try {
            Document buildInfoResult = adminDb.runCommand((Bson)new BsonDocument("buildinfo", (BsonValue)new BsonString("")));
            if (!buildInfoResult.isEmpty()) {
                Object result = buildInfoResult.get((Object)"versionArray");
                if (!(result instanceof ArrayList)) {
                    LOG.warn("Couldn't retrieve MongoDB buildInfo");
                    return null;
                }
                ArrayList versionArray = (ArrayList)buildInfoResult.get((Object)"versionArray", ArrayList.class);
                if (versionArray == null || versionArray.size() < 3) {
                    LOG.debug("Couldn't retrieve MongoDB version");
                    return null;
                }
                int majorVersion = (Integer)versionArray.get(0);
                int minorVersion = (Integer)versionArray.get(1);
                int patchVersion = (Integer)versionArray.get(2);
                return Version.of((long)majorVersion, (long)minorVersion, (long)patchVersion);
            }
            LOG.warn("Couldn't retrieve MongoDB buildInfo");
            return null;
        }
        catch (MongoException e) {
            LOG.warn("Couldn't retrieve MongoDB buildInfo", (Throwable)e);
            return null;
        }
    }

    public static void assertCompatibleVersion(Version mongoVersion) {
        if (mongoVersion != null && mongoVersion.isLowerThan(MINIMUM_MONGODB_VERSION)) {
            throw new PreflightCheckException(StringUtils.f("You're running MongoDB %s but Graylog requires at least MongoDB %s. Please upgrade.", mongoVersion, MINIMUM_MONGODB_VERSION));
        }
    }
}

