/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.export;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shiro.subject.Subject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog.plugins.views.search.searchtypes.Sort;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.shared.security.EntityPermissionsUtils;

public class MongoCollectionExportService {
    private final MongoConnection mongoConnection;
    private final EntityPermissionsUtils permissionsUtils;

    @Inject
    public MongoCollectionExportService(MongoConnection mongoConnection, EntityPermissionsUtils permissionsUtils) {
        this.mongoConnection = mongoConnection;
        this.permissionsUtils = permissionsUtils;
    }

    public List<Document> export(String collectionName, List<String> exportedFieldNames, int limit, Bson dbFilter, List<Sort> sorts, Subject subject) {
        MongoCollection collection = this.mongoConnection.getMongoDatabase().getCollection(collectionName);
        FindIterable resultsWithoutLimit = collection.find(Objects.requireNonNullElse(dbFilter, Filters.empty())).projection(Projections.fields((Bson[])new Bson[]{Projections.include(exportedFieldNames)})).sort(this.toMongoDbSort(sorts));
        boolean userCanReadAllEntities = this.permissionsUtils.hasAllPermission(subject) || this.permissionsUtils.hasReadPermissionForWholeCollection(subject, collectionName);
        Predicate<Document> checkPermission = this.permissionsUtils.createPermissionCheck(subject, collectionName);
        Stream<Document> documents = userCanReadAllEntities ? this.getFromMongo((FindIterable<Document>)resultsWithoutLimit, limit) : this.getWithInMemoryPermissionCheck((FindIterable<Document>)resultsWithoutLimit, limit, checkPermission);
        return documents.collect(Collectors.toList());
    }

    private Bson toMongoDbSort(List<Sort> sorts) {
        return Sorts.orderBy(sorts.stream().map(srt -> srt.order() == Sort.Order.DESC ? Sorts.descending((String[])new String[]{srt.field()}) : Sorts.ascending((String[])new String[]{srt.field()})).toList());
    }

    private Stream<Document> getWithInMemoryPermissionCheck(FindIterable<Document> result, int limit, Predicate<Document> checkPermission) {
        return MongoUtils.stream(result).filter(checkPermission).limit(limit);
    }

    private Stream<Document> getFromMongo(FindIterable<Document> result, int limit) {
        return MongoUtils.stream(result.limit(limit));
    }
}

