/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.filtering;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.graylog2.database.filtering.Filter;
import org.graylog2.database.filtering.inmemory.SingleFilterParser;
import org.graylog2.rest.resources.entities.EntityAttribute;

public class DbFilterExpressionParser {
    private final SingleFilterParser singleFilterParser = new SingleFilterParser();

    public List<Bson> parse(List<String> filterExpressions, List<EntityAttribute> attributes) {
        if (filterExpressions == null || filterExpressions.isEmpty()) {
            return List.of();
        }
        Map<String, List<Filter>> groupedByField = filterExpressions.stream().map(expr -> this.singleFilterParser.parseSingleExpression((String)expr, attributes)).collect(Collectors.groupingBy(Filter::field));
        return groupedByField.values().stream().map(grouped -> grouped.stream().map(Filter::toBson).collect(Collectors.toList())).map(groupedFilters -> {
            if (groupedFilters.size() == 1) {
                return (Bson)groupedFilters.get(0);
            }
            return Filters.or((Iterable)groupedFilters);
        }).toList();
    }

    public Bson parseSingleExpression(String filterExpression, List<EntityAttribute> attributes) {
        Filter filter = this.singleFilterParser.parseSingleExpression(filterExpression, attributes);
        return filter.toBson();
    }
}

