/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.filtering;

import com.mongodb.client.model.Filters;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.database.filtering.DbFilterExpressionParser;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryParser;

public class DbQueryCreator {
    private final DbFilterExpressionParser dbFilterParser;
    private final SearchQueryParser searchQueryParser;
    private final List<EntityAttribute> attributes;
    static final Document EMPTY_QUERY = new Document();

    public DbQueryCreator(String defaultField, List<EntityAttribute> attributes) {
        this.dbFilterParser = new DbFilterExpressionParser();
        this.attributes = attributes;
        this.searchQueryParser = new SearchQueryParser(defaultField, attributes);
    }

    DbQueryCreator(DbFilterExpressionParser dbFilterParser, SearchQueryParser searchQueryParser, List<EntityAttribute> attributes) {
        this.dbFilterParser = dbFilterParser;
        this.searchQueryParser = searchQueryParser;
        this.attributes = attributes;
    }

    public Bson createDbQuery(List<String> filters, String query) {
        try {
            SearchQuery searchQuery = this.searchQueryParser.parse(query);
            List<Bson> filterExpressionFilters = this.dbFilterParser.parse(filters, this.attributes);
            return this.buildDbQuery(searchQuery, filterExpressionFilters);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
    }

    private Bson buildDbQuery(SearchQuery searchQuery, List<Bson> filterExpressionFilters) {
        List<Bson> searchQueryFilters = searchQuery.toBsonFilterList();
        if (!this.hasItems(searchQueryFilters) && !this.hasItems(filterExpressionFilters)) {
            return EMPTY_QUERY;
        }
        if (this.hasItems(filterExpressionFilters)) {
            ArrayList<Bson> filterList = new ArrayList<Bson>(searchQueryFilters);
            filterList.addAll(filterExpressionFilters);
            return Filters.and(filterList);
        }
        return Filters.and(searchQueryFilters);
    }

    private boolean hasItems(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }
}

