/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.filtering;

import com.mongodb.client.model.Filters;
import java.util.Objects;
import java.util.function.Predicate;
import org.bson.conversions.Bson;
import org.graylog2.database.filtering.Filter;
import org.graylog2.database.filtering.inmemory.InMemoryFilterable;

public record SingleValueFilter(String field, Object value) implements Filter
{
    @Override
    public Bson toBson() {
        return Filters.eq((String)this.field(), (Object)this.value());
    }

    @Override
    public Predicate<InMemoryFilterable> toPredicate() {
        return o -> o.extractFieldValue(this.field).map(fieldValue -> fieldValue.equals(this.value)).orElse(false);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleValueFilter that = (SingleValueFilter)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.value);
    }
}

